# -*- encoding: utf-8 -*-
##############################################################################
#
#    Personalizzazione realizzata da Francesco OpenCode Apruzzese (f.apruzzese@andreacometa.it)
#    Compatible with OpenERP release 6.0.X
#    Copyright (C) 2010 Andrea Cometa. All Rights Reserved.
#    Email: info@andreacometa.it, f.apruzzese@andreacometa.it
#    Web site: http://www.andreacometa.it
#
##############################################################################

from osv import fields, osv
import os
from tools.translate import _

class res_partner(osv.osv):

	_name = "res.partner"
	_inherit = "res.partner"

	def pi_cf_esistenti(self, cr, uid, vals, ids=False):
		if ('vat' in vals) and vals['vat']:
			partner_pi_esistente_ids = self.pool.get('res.partner').search(cr, uid, [('vat', '=', vals['vat'])])
			if ids and ids in partner_pi_esistente_ids:
				partner_attuale_id = partner_pi_esistente_ids.index(ids)
				partner_pi_esistente_ids = partner_pi_esistente_ids.remove(ids)
			# ----- Se esiste solleva un errore
			if partner_pi_esistente_ids:
				raise osv.except_osv(_('Attenzione!'), _('Partita IVA già esistente per un altro partner!'))
				return False
		if ('fiscalcode'in vals) and vals['fiscalcode']:
			partner_fc_esistente_ids = self.pool.get('res.partner').search(cr, uid, [('fiscalcode', '=', vals['fiscalcode'])])
			if ids and ids in partner_fc_esistente_ids:
				partner_attuale_id = partner_fc_esistente_ids.index(ids)
				partner_fc_esistente_ids = partner_fc_esistente_ids.remove(ids)
			# ----- Se esiste solleva un errore
			if partner_fc_esistente_ids:
				raise osv.except_osv(_('Attenzione!'), _('Codice Fiscale già esistente per un altro partner!'))
				return False
		return True

	#-----------------------------------------------------------------------------
	# OVERLOADING DI CREATE PER CREARE UN PARTNER CON PI E CF UNIVOCI
	#-----------------------------------------------------------------------------
	def create(self, cr, uid, vals, context=None):
		# ----- cerca un partner con la stessa partita IVA o codice fiscale
		self.pi_cf_esistenti(cr, uid, vals)
		partner_id = super(res_partner, self).create(cr, uid, vals, context)
		return partner_id

	#-----------------------------------------------------------------------------
	# OVERLOADING DI WRITE PER SCRIVERE PI E CF UNIVOCI
	#-----------------------------------------------------------------------------
	def write(self, cr, uid, ids, vals, context=None):
		# ----- cerca un partner con la stessa partita IVA o codice fiscale
		if not (context and 'client' in context and context['client'] == 'web'):
			partner_id = False
		else:
			partner_id = ids[0]
		self.pi_cf_esistenti(cr, uid, vals, partner_id)
		partner_id = super(res_partner, self).write(cr, uid, ids, vals, context)
		return partner_id

	#-----------------------------------------------------------------------------
	# OVERLOADING DI WRITE PER EVITARE LA COPIA DI PI E CF
	#-----------------------------------------------------------------------------
	def copy(self, cr, uid, id, values, context=None):
		partner = self.browse(cr, uid, id)
		vat = partner.vat
		cf = partner.fiscalcode
		self.write(cr, uid, [id,], {'vat':'', 'fiscalcode':''})
		res = super(res_partner, self).copy(cr, uid, id, values, context)
		self.write(cr, uid, [id,], {'vat':vat, 'fiscalcode':cf})
		return res

res_partner()
