# -*- coding: utf-8 -*-
##############################################################################
#    
#    Copyright (C) 2011 DeneroTeam. (<http://www.deneroteam.com>)
#    All Rights Reserved
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as published
#    by the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################
from osv import fields, osv
from tools.translate import _
import time
class asset_move_create(osv.osv_memory):
    _name = "asset.move.create"
    _description = "Create Asset Move"
    _columns = {
            "dest_location" : fields.reference("Destination Location", [
                                ('res.partner','Customer'),
                                ('hr.employee','Employee'),
                                ('project.project','Project'),
                                ('stock.location','Warehouse'),
                                ('res.car','Car')], size=128, required=True),
            "user_id" : fields.many2one("res.users","Moved By",required=True),
    }
    def asset_move_create(self, cr, uid, ids, context=None):
        if context is None:
            context = {}
        context_id = context and context.get('active_id', False) or False
        asset_ids = context and context.get('active_ids',[]) or []
        obj_asset = self.pool.get('asset.asset')
        obj_move = self.pool.get('asset.move')
        for data in self.read(cr, uid, ids, context=context):
            for id in asset_ids:
                asset = obj_asset.read(cr,uid,[id])[0]
                if asset :
                    source_location = asset['location'] or False
                    dest_location = data['dest_location'] or False
                    if not source_location:
                        model_name = 'res.partner'
                        id = asset['res_partner_id'][0] or 0
                        source_location = model_name + ',' + str(id)
                    if source_location != dest_location:
                        move_id = obj_move.create(cr,uid,{
                            'name' : self.pool.get('ir.sequence').get(cr, uid, 'asset.move'),
                            'datetime' : time.strftime('%Y-%m-%d %H:%M:%S'),
                            'source_location':source_location,
                            'dest_location' : dest_location,
                            'asset_id' : asset['id']
                        })
                        if move_id:
                            obj_asset.write(cr, uid,[asset['id']],{'location':dest_location})
        return {'type': 'ir.actions.act_window_close'}
    _defaults = {
        'user_id': lambda self, cr, uid, context: uid,
    }
asset_move_create()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4: