# -*- coding: utf-8 -*-
##############################################################################
#    
#    Copyright (C) 2011 DeneroTeam. (<http://www.deneroteam.com>)
#    All Rights Reserved
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as published
#    by the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################
from osv import fields, osv
import time
import sys, traceback

class asset_category(osv.osv):
    #def name_get(self, cr, uid, ids, context=None):
    #    if not len(ids):
    #        return []
    #    reads = self.read(cr, uid, ids, ['name','parent_id'], context=context)
    #    res = []
    #    for record in reads:
    #        name = record['name']
    #        if record['parent_id']:
    #            name = record['parent_id'][1]+' / '+name
    #        res.append((record['id'], name))
    #    return res
    #def _name_get_fnc(self, cr, uid, ids, prop, unknow_none, context=None):
    #    res = self.name_get(cr, uid, ids, context=context)
    #    return dict(res)
    
    _name = "asset.category"
    _columns = {
        'name': fields.char('Name', size=64, required=True, translate=True),
        'code': fields.char('Code', size=16, required=True),
        'has_date_option': fields.boolean('Has date options ?'),
        #'complete_name': fields.function(_name_get_fnc, method=True, type="char", string='Name'),
        #'parent_id': fields.many2one('asset.category','Parent Category', select=True),
        #'child_ids': fields.one2many('asset.category', 'parent_id', string='Child Categories'),
        #'sequence': fields.integer('Sequence', help="Gives the sequence order when displaying a list of Asset categories."),
        #'type': fields.selection([('view','View'), ('normal','Normal')], 'Category Type'),
    }
    #_defaults = {
    #    'type' : 'view',
    #}
asset_category()

class asset_image(osv.osv):
    _name = "asset.image"
    _column = {
        "asset_id" : fields.many2one("asset.asset", "Asset"),
        "name" : fields.char("Name",size=64),
        "file" : fields.binary("Image"),
    }
asset_image()
class asset_product(osv.osv):
    _name = "asset.product"
    _columns = {
        "name" : fields.char("Type Name", size=64, required=True),
        "code" : fields.char("Type Code", size=8 , required=True),
        "user" : fields.many2one("hr.employee","Manager"),
        "category_id" : fields.many2one("asset.category","Category", required=True),
        "uom_id": fields.many2one('product.uom', 'Default Unit Of Measure'),
        "barcode" : fields.char("Barcode", size=16),
        'has_date_option': fields.boolean('Has date options ?'),
        "asset_ids": fields.one2many('asset.asset', 'product_id', string='Assets'),
        
    }

    
    def onchange_category_id(self, cr, uid, ids, category_id, context=None):
        has_date_option = False
        if category_id:
            category_id_obj = self.pool.get('asset.category')
            category_type = category_id_obj.browse(cr,uid,[category_id],context)
            if category_type and category_type[0].has_date_option == True:has_date_option = True
        return {'value': {'has_date_option': has_date_option}}
        
asset_product()


class asset_asset(osv.osv):
    _name = "asset.asset"
    def name_get(self, cr, uid, ids, context=None):
        if not len(ids):
            return {}
        reads = self.read(cr, uid, ids, ['product_id','track_no'], context=context)
        res = []
        for record in reads:
            name = ""
            if record['track_no']:
                name = "["+ record['track_no']+"] "
            if record['product_id']:
                name = name + record['product_id'][1]
            res.append((record['id'], name))
        return dict(res)
    def _name_get_fnc(self, cr, uid, ids, prop, unknow_none, context=None):
        res = self.name_get(cr, uid, ids, context=context)
        return dict(res)
    def _name_get_location(self, cr, uid, ids, prop, unknow_none, context=None):
        if not len(ids):
            return []
        reads = self.read(cr, uid, ids, ['id','location'], context=context)
        res = []
        for record in reads:
            try:
                (model_name, obj_id) = record['location'].split(',')
                if model_name and obj_id:
                    obj_id = int(obj_id)
                    model = self.pool.get(model_name)
                    obj_name = model.name_get(cr,uid,[obj_id])[0]
                    if obj_name and len(obj_name) > 1 :
                        res.append((record['id'],"[ " + model_name + " ] " + obj_name[1]))
            except:
                print repr(traceback.extract_tb(sys.exc_traceback))
        return dict(res)
    
    def _get_assigned_assets(self, cr, uid, ids, prop, unknow_none, context=None):
        if not len(ids):
            return {}
        model_name = self._name
        res = []
        try:
            for id in ids:
                res.append((id,self.pool.get('asset.asset').search(cr,uid,[('location','=',model_name + ',' + str(id))])))
        except:
            print repr(traceback.extract_tb(sys.exc_traceback))
        return dict(res)    
    _columns = {
        "product_id" : fields.many2one("asset.product", "Asset Product", required=True),
        'complete_name': fields.function(_name_get_fnc, method=True, type="char", string='Name'),
        'location_name' : fields.function(_name_get_location, method=True, type="char", string="Current Location"),
        "track_no" : fields.char("Track Number", size=16,required=True),
        "barcode" : fields.char("Bar Code", size=16),
        "company_id" : fields.many2one("res.company","Company"),
        "purchase_price" : fields.float("Purchase Price", size=16),
        "res_partner_id" : fields.many2one("res.partner", "Vendor", required=True),
        "ven_prod_name" : fields.char("Vendor Product Name",size=64),
        "ven_prod_code" : fields.char("Vendor Product code",size=64),
        "location" : fields.reference("Current Location", [
                                ('asset.asset','Asset'),
                                ('res.partner','Customer'),
                                ('hr.employee','Employee'),
                                ('project.project','Project'),
                                ('stock.location','Warehouse'),
                                ('res.car','Car')], size=128),
        "note" : fields.text("Note"),
        "image" : fields.binary("Image"),
        'date_start' : fields.datetime("Starting Date"),
        'date_end' : fields.datetime("Ending Date"),
        'has_date_option': fields.boolean('Has date options ?'),
        #'document_ids': fields.one2many('asset.document', 'asset_id', 'Documents'),
        
        'asset_ids':fields.function(_get_assigned_assets, method=True, string='Assets', type='one2many', relation="asset.asset"),
        
    }
    #_sql_constraints = [('track_number_uniq','unique(track_no)', 'Track Number must be unique!')]
    _defaults = {
        'company_id': lambda self,cr,uid,c: self.pool.get('res.users').browse(cr, uid, uid, c).company_id.id,
    }
    
    def _check_dates(self, cr, uid, ids, context=None):
        for i in self.read(cr, uid, ids, ['has_date_option','date_start', 'date_end'], context=context):
            if i['has_date_option'] and i['date_start'] >= i['date_end']:
                return False
        return True

    _constraints = [(_check_dates, 'Error! Documents start date must be lower then contract end date.', ['has_date_option','date_start', 'date_end'])]  
   
    def onchange_product_id(self, cr, uid, ids, product_id, context=None):
        has_date_option = False
        if product_id:
            product_id_obj = self.pool.get('asset.product')
            product_type = product_id_obj.browse(cr,uid,[product_id],context)
            if product_type and product_type[0].has_date_option == True:has_date_option = True
        return {'value': {'has_date_option': has_date_option}}
        
asset_asset()

class resource_resource(osv.osv):
    _inherit = "resource.resource"
    _columns = {
        "asset_id" : fields.many2one("asset.asset", "Asset"),
    }
resource_resource()

class asset_move(osv.osv):
    _name = "asset.move"
    def _name_get_slocation(self, cr, uid, ids, prop, unknow_none, context=None):
        if not len(ids):
            return []
        reads = self.read(cr, uid, ids, ['id','source_location'], context=context)
        res = []
        for record in reads:
            try:
                (model_name, obj_id) = record['source_location'].split(',')
                if model_name and obj_id:
                    obj_id = int(obj_id)
                    model = self.pool.get(model_name)
                    obj_name = model.name_get(cr,uid,[obj_id])[0]
                    if obj_name and len(obj_name) > 1 :
                        print (record['id'],"[ " + model_name + " ] " + obj_name[1])
                        res.append((record['id'],"[ " + model_name + " ] " + obj_name[1]))
            except:
                print repr(traceback.extract_tb(sys.exc_traceback))
        return dict(res)
        
    def _name_get_dlocation(self, cr, uid, ids, prop, unknow_none, context=None):
        if not len(ids):
            return []
        reads = self.read(cr, uid, ids, ['id','dest_location'], context=context)
        res = []
        for record in reads:
            try:
                (model_name, obj_id) = record['dest_location'].split(',')
                if model_name and obj_id:
                    obj_id = int(obj_id)
                    model = self.pool.get(model_name)
                    obj_name = model.name_get(cr,uid,[obj_id])[0]
                    if obj_name and len(obj_name) > 1 :
                        print (record['id'],"[ " + model_name + " ] " + obj_name[1])
                        res.append((record['id'],"[ " + model_name + " ] " + obj_name[1]))
            except:
                print repr(traceback.extract_tb(sys.exc_traceback))
        return dict(res)
    _columns = {
        "name" : fields.char('Name', size=64, required=True, translate=True),
        "source_location" : fields.reference("Source Location", [
                                ('res.partner','Customer'),
                                ('hr.employee','Employee'),
                                ('project.project','Project'),
                                ('stock.location','Warehouse'),
                                ('res.car','Car')], size=128),
        "dest_location" : fields.reference("Destination Location", [
                                ('res.partner','Customer'),
                                ('hr.employee','Employee'),
                                ('project.project','Project'),
                                ('stock.location','Warehouse'),
                                ('res.car','Car')], size=128),
        "datetime" : fields.datetime("Datetime", required=True),
        "asset_id" : fields.many2one("asset.asset","Asset",required=True),
        "user_id" : fields.many2one("res.users","Moved By", readonly=True),
        'source_location_name' : fields.function(_name_get_slocation, method=True, type="char", string="Source Loc."),
        'dest_location_name' : fields.function(_name_get_dlocation, method=True, type="char", string="Destination Loc."),
    }
    _defaults = {
        'name' : lambda self, cr, uid, context: self.pool.get('ir.sequence').get(cr, uid, 'asset.move'),
        'datetime' : lambda *args: time.strftime('%Y-%m-%d %H:%M:%S'),
        'user_id': lambda self, cr, uid, context: uid,
    }
asset_move()




class asset_asset1(osv.osv):
    _inherit = "asset.asset"
    _columns = {
        "asset_moves": fields.one2many('asset.move', 'asset_id', string='Asset Moves',readonly=True),
        "document_ids" : fields.one2many("asset.document",'asset_id',"Document"),
    }
asset_asset1()

class hr_employee(osv.osv):
    _description = "Employee"
    _inherit = 'hr.employee'
    def _get_assigned_assets(self, cr, uid, ids, prop, unknow_none, context=None):
        if not len(ids):
            return {}
        model_name = super(hr_employee,self)._name
        res = []
        try:
            for id in ids:
                res.append((id,self.pool.get('asset.asset').search(cr,uid,[('location','=',model_name + ',' + str(id))])))
        except:
            print repr(traceback.extract_tb(sys.exc_traceback))
        return dict(res)
    _columns = {
        'asset_ids':fields.function(_get_assigned_assets, method=True, string='Assets', type='one2many', relation="asset.asset"),
    }
hr_employee()
class res_car(osv.osv):
    _inherit = 'res.car'
    def _get_assigned_assets(self, cr, uid, ids, prop, unknow_none, context=None):
        if not len(ids):
            return {}
        model_name = super(res_car,self)._name
        res = []
        try:
            for id in ids:
                res.append((id,self.pool.get('asset.asset').search(cr,uid,[('location','=',model_name + ',' + str(id))])))
        except:
            print repr(traceback.extract_tb(sys.exc_traceback))
        return dict(res)
    _columns = {
        'asset_ids':fields.function(_get_assigned_assets, method=True, string='Assets', type='one2many', relation="asset.asset"),
    }
res_car()

class asset_document_type(osv.osv):
    _description = "Documents Types"
    _name = 'asset.document.type'
    _columns = {
        'name': fields.char("Document Type", size=256, required=True),
        'code': fields.char("Code", size=64),
        'has_date_option1': fields.boolean('Has date options ?'),
    }
asset_document_type()

class asset_document(osv.osv):
    _description = "Asset Document"
    _name = 'asset.document'
    _columns = {
        'name': fields.char("Document", size=256, required=True),
        'document_type_id':fields.many2one('asset.document.type','Document Type'),
        'asset_id':fields.many2one('asset.asset','Asset',ondelete='cascade', required=True),
        'valid_start_date': fields.date("Valid Start Date"),
        'valid_end_date': fields.date("Valid End Date"),
        'comments': fields.text('Comments'),
        'has_date_option1': fields.boolean('Has date options ?'),
        'active': fields.boolean('Active'),
    }
    _defaults = {
        'active': 1,
    }
    
    def _check_dates(self, cr, uid, ids, context=None):
        for i in self.read(cr, uid, ids, ['has_date_option1','valid_start_date', 'valid_end_date'], context=context):
            if i['has_date_option1'] and i['valid_start_date'] >= i['valid_end_date']:
                return False
        return True

    _constraints = [(_check_dates, 'Error! Documents start date must be lower then contract end date.', ['has_date_option1','valid_start_date', 'valid_end_date'])]  
    
    def onchange_document_type_id(self, cr, uid, ids, document_type_id, context=None):
        has_date_option1 = False
        if document_type_id:
            document_type_obj = self.pool.get('asset.document.type')
            document_type = document_type_obj.browse(cr,uid,[document_type_id],context)
            if document_type and document_type[0].has_date_option1 == True:has_date_option1 = True
        return {'value': {'has_date_option1': has_date_option1}}
asset_document()



# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4: