# -*- coding: utf-8 -*-
##############################################################################
#    
#    OpenERP, Open Source Management Solution
#
#    Copyright (C) 2012 Manuel Abadia
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     
#
##############################################################################

from osv import fields,osv

class stock_picking(osv.osv):
    _inherit = 'stock.picking'

    _columns = {
        'carrier_id':fields.many2one("delivery.carrier","Carrier used for shipping"),
        'invoice_shipping_after_picking': fields.boolean("Auto-Invoice Delivery", help="Check this field if you plan to invoice the shipping based on picking."),
    }

    _defaults = {
        'invoice_shipping_after_picking': lambda *a: 1,
    }

    def _prepare_shipping_invoice_line(self, cr, uid, picking, invoice, context=None):
        if not picking.invoice_shipping_after_picking:
            return None

        return super(stock_picking, self)._prepare_shipping_invoice_line(cr, uid, picking, invoice, context=context)

stock_picking()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:

