# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#
#    Copyright (C) 2012 Manuel Abadia
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import fields,osv

class sale_order(osv.osv):
    _inherit = 'sale.order'
    _columns = {
        'carrier_id':fields.many2one("delivery.carrier", "Delivery Method", help="Carrier used for shipping."),
        'invoice_shipping_after_picking': fields.boolean("Auto-Invoice Delivery", help="Check this field if you plan to invoice the shipping based on picking."),
        'id': fields.integer('ID', readonly=True,invisible=True),
    }

    _defaults = {
        'invoice_shipping_after_picking': lambda *a: 1,
    }

    def _prepare_order_picking(self, cr, uid, order, context=None):
        result = super(sale_order, self)._prepare_order_picking(cr, uid, order, context=context)
        result.update(carrier_id=order.carrier_id.id)
        result.update(invoice_shipping_after_picking=order.invoice_shipping_after_picking)
        return result

sale_order()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:

