# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#
#    Copyright (C) 2012 Manuel Abadia
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

{
        "name" : "manu_delivery_no_auto_invoice",
        "version" : "0.1",
        "author" : "Manuel Abadia",
        "website" : "http://www.tiedra.net",
        "category" : "Sales Management",
        "description": """
The standard delivery module has a field called carrier_id, displayed as Delivery Method that is used to track the carrier used but also has a second meaning: 
when the field is set, it means that the system should compute the shipping costs of the picking when creating the invoice for the picking. 

This module splits this functionality in two parts: support for carrier tracking and auto invoice delivery.

This is useful to track the carried used if you use the 'Delivery Costs' button in the sales order to add the delivery costs to the sale order.

The detailed changes are:
* I have added another field to the sale.order and to the stock.picking called invoice_shipping_after_picking (displayed as Auto-Invoice Delivery) that controls if the system needs to add the delivery line to the invoice.
* the carrier_id field (displayed as Delivery Method) will be used to indicate the carrier used to ship the order, and in the picking the carrier used to ship the picking. This way I have splitted the previous functionality of the carrier_id field in two fields as it was really doing two things (specifying the carrier and telling the system to invoice the delivery after picking).
* I have changed the wizard that adds the delivery costs to a sale.order. Now when the delivery costs are added to the sale order, the carrier_id is set to the carrier selected in the wizard and the invoice_shipping_after_picking field is set to false as the delivery line has been added. If the user never clicks on the Delivery Cost button, the system will behave as expected as the default value for invoice_shipping_after_picking is true.
* when creating the invoice from the picking, I check the invoice_shipping_after_picking field and if it is not set, it won't try to add the delivery line to the invoices.

With this solution you can know the carrier used if you add the delivery costs manually or if they will get added later.""",
        "depends" : ["delivery"],
        "init_xml" : [ ],
        "demo_xml" : [ ],
        "update_xml" : ['delivery_view.xml'],
        "installable": True
}

