# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution	
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import fields
from osv import osv
import time

class res_partner(osv.osv):
    _inherit='res.partner'
    def read(self, cr, user, ids, fields_to_read=None, context=None, load='_classic_read'):
        if context and context.get('audittrail_res.partner', False):
            dt = context.get('audittrail_res.partner', False)
            model_id = self.pool.get('ir.model').search(cr, user, [('model','=','res.partner')])[0]
            result = super(res_partner, self).read(cr, user, ids, fields_to_read, context, load) 
            for r in result:
                done = {}
                cr.execute('select l.old_value,l.field_id from audittrail_log_line l left join audittrail_log o on (o.id=l.log_id) where o.method=%s and o.object_id=%s and o.res_id=%s and o.timestamp>=%s order by o.timestamp desc', ('write',model_id,r['id'], dt))
                for value,field_id in cr.fetchall():
                    if field_id in done:
                        continue
                    done[field_id]= True
                    field_name = self.pool.get('ir.model.fields').browse(cr, user, field_id, context).name
                    # TODO: Improve here, remove this code and check special cases (O2M, M2M)
                    if field_name <> 'name':
                        continue
                    r[field_name] = value
            return result
        return super(res_partner, self).read(cr, user, ids, fields_to_read, context, load) 
res_partner()


