# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution	
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import fields
from osv import osv
import time

class related_historical(fields.related):
    def _fnct_read(self, obj, cr, uid, ids, field_name, args, context=None):
        self._field_get2(cr, uid, obj, context)
        if not ids: return {}
        relation = obj._name
        res = {}.fromkeys(ids, False)
        objlst = obj.browse(cr, uid, ids)
        for data in objlst:
            if not data:
                continue
            t_data = data
            relation = obj._name
            for i in range(len(self.arg)):
                field_detail = self._relations[i]
                relation = field_detail['object']
                try:
                    if not t_data[self.arg[i]]:
                        t_data = False
                        break
                except:
                    t_data = False
                    break
                if field_detail['type'] in ('one2many', 'many2many'):
                    if ('historical_'+self.arg[i]) in context:
                        found = False
                        for t in t_data[self.arg[i]]:
                            if eval(context['historical_'+self.arg[i]], {'obj':t, 'context':context}):
                                t_data = t
                                found = True
                        if not found:
                            t_data = t_data[self.arg[i]][0]
                    else:
                        t_data = t_data[self.arg[i]][0]
                else:
                    t_data = t_data[self.arg[i]]
            if type(t_data) == type(objlst[0]):
                res[data.id] = t_data.id
            else:
                res[data.id] = t_data

        if self._type=='many2one':
            ids = filter(None, res.values())
            if ids:
                ng = dict(obj.pool.get(self._obj).name_get(cr, uid, ids, context=context))
                for r in res:
                    if res[r]:
                        res[r] = (res[r], ng[res[r]])
        return res


class insurance_contract(osv.osv):
    _name='insurance.contract'
    _columns = {
        'name': fields.char('Contract Name', size=32, required=True),
        'customer_id': fields.many2one('res.partner','Customer',required=True),
        'version_ids': fields.one2many('insurance.contract.version', 'contract_id', 'Contract Versions'),
        'insurance_code': related_historical('version_ids','insurance_code', type="char", string='Police ID', size=16, readonly=True),
        'insurance_partner_id': related_historical('version_ids','insurance_partner_id', type="many2one", relation='res.partner', string='Insurer', readonly=True),
        'date_from': related_historical('version_ids','date_from', type="date", string='Date Start', readonly=True),
        'date_to': related_historical('version_ids','date_to', type="date", string='Date To', readonly=True),
    }
insurance_contract()


class insurance_contract_version(osv.osv):
    _name='insurance.contract.version'
    _rec_name='note'
    _order='date_from desc'
    _columns = {
        'contract_id': fields.many2one('insurance.contract', required=True, ondelete='set null'),
        'insurance_code': fields.char('Police ID', size=16, required=True),
        'insurance_partner_id': fields.many2one('res.partner', 'Insurer', required=True),
        'date_from': fields.date('Date Start'),
        'date_to': fields.date('Date To'),
        'note': fields.text('Descritpion'),
    }
    _defaults = {
        'date_from': lambda *a: time.strftime('%Y-%m-%d')
    }
insurance_contract_version()

class insurance_case(osv.osv):
    _name='insurance.case'
    def _contract_compute(self, cr, uid, ids, name, arg, context):
        res = {}
        for case in self.browse(cr, uid, ids, context):
            r = self.contract_change(cr, uid, ids, case.customer_id.id, case.date, case.contract_id.id, context)
            res[case.id] = r.get('value', False).get('data','')
        return res
    def contract_change(self, cr, uid, ids, customer_id, date, contract_id, context={}):
        if not contract_id: return {'value': {'data':''}}
        contract = self.pool.get('insurance.contract').browse(cr, uid, contract_id)
        for version in contract.version_ids:
            if version.date_from<=date and version.date_to>=date:
                return {'value': {'data': 'Insurer: '+version.insurance_partner_id.name + '\nContract ID: ' + version.insurance_code}}
        return {'value': {'data': ''}}
    _columns = {
        'name': fields.char('Case Subject', size=32, required=True),
        'customer_id': fields.many2one('res.partner', 'Customer', required=True),
        'date': fields.datetime('Case Date', required=True),
        'contract_id': fields.many2one('insurance.contract','Contract', required=True),
        'note': fields.text('Case Description'),
        'data': fields.function(_contract_compute, method=True, string='Data',type='text')
    }
insurance_case()


