# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (c) 2010 Domatix Technologies  S.L. (http://www.domatix.com) 
#                       info <info@domatix.com>
#                        Angel Moya <angel.moya@domatix.com>
#
#        $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see http://www.gnu.org/licenses/.
#
##############################################################################
import string

from osv import osv, fields


class res_country(osv.osv):
    _inherit = 'res.country'
    
    _columns = {
        'vat_except': fields.boolean('Allow exception in VAT validator'),
        }
    
    _defaults = {
        'vat_except': lambda *a: False,
        }
    
res_country()

class res_partner(osv.osv):
    _inherit = 'res.partner'

    def check_vat(self, cr, uid, ids, context=None):
        
        for partner in self.browse(cr, uid, ids, context=context):
            if not partner.vat:
                continue
            vat_country, vat_number = self._split_vat(partner.vat)
            country_obj = self.pool.get('res.country')
            country_id = country_obj.search(cr,uid,[('code', '=', vat_country.upper())])
            for country in country_obj.browse(cr,uid,country_id):
                if country and country.vat_except == True :
                    return True
            
            return super(res_partner, self).check_vat(cr, uid, ids, context=context)
        
        return True

    def _construct_constraint_msg(self, cr, uid, ids, context=None):

        return super(res_partner, self)._construct_constraint_msg(cr, uid, ids, context=context)
    
    _constraints = [(check_vat, _construct_constraint_msg, ["vat"])]
    
res_partner()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
