# -*- coding: utf-8 -*-
##############################################################################
#
#    training_ubercart_webshop module for OpenERP, Fetch ubercart orders from IFBL Website
#    Copyright (C) 2011 Thamini SàRL (<http://http://www.thamini.lu) Jean-Christophe VASSORT
#
#    This file is a part of training_ubercart_webshop
#
#    training_ubercart_webshop is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    training_ubercart_webshop is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv, fields
import drupal_client
from tools.translate import _

class drupal_connexion(osv.osv):
    _name = "drupal.connexion"
    _description = "Drupal Connexion"

    _columns = {
        'name': fields.char('Drupal Connexion Name', size=64, required=True),
        'active': fields.boolean('Active'),
        'hostname': fields.char('Drupal URL', size=512, required=True),
        'domain': fields.char('Drupal XMLRPC service domain', size=512, required=True),
        'api_key': fields.char('Drupal XMLRPC service API Key', size=32, required=True),
        'path': fields.char('Drupal XMLRPC service path', size=32, required=True),
        'user': fields.char('User', size=128, required=True),
        'password': fields.char('Password', size=128, required=True),
        'proto': fields.selection([('http', 'http'),
                                  ('https', 'https'),], 'Protocole'),
        'pt': fields.boolean('Use proxy'),
        'p_hostname': fields.char('Proxy hostname', size=512),
        'p_port': fields.integer('Proxy port'),
        'description': fields.text('Description'),
    }

    _defaults = {
        'pt': lambda *a: False,
        'proto': lambda *a: 'http',
        'p_hostname': lambda *a: None,
        'active': lambda *a: True,
    }

    def drupal_connect(self, cr, uid, drupal_config_id, context=None):
        if type(drupal_config_id) is list:
            drupal_config_id = drupal_config_id[0]

        res = self.read(cr, uid, drupal_config_id)
        dpc = drupal_client.drupal_connection(hostname = res['hostname'].encode('utf-8'),
                                              domain = res['domain'].encode('utf-8'),
                                              api_key = res['api_key'].encode('utf-8'),
                                              path = res['path'].encode('utf-8'),
                                              proto = res['proto'].encode('utf-8'),
                                              pt = res['pt'],
                                              p_hostname = res['p_hostname'] and res['p_hostname'].encode('utf-8') or False,
                                              p_port = res['p_port'],
                                            )
        dpc.connect(res['user'].encode('utf-8'), res['password'].encode('utf-8'))

        return dpc

    def dpc(self, cr, uid, drupal_config_id = None, context=None):
        """ return a drupal connexion"""
        if drupal_config_id is None:
            # get drupal config id
            raise osv.except_osv(('Warning'), 'drupal_config_id missing')
        # get drupal object
        drupal = self.browse(cr, uid, drupal_config_id, context=context)

        # drupal connexion
        return self.drupal_connect(cr, uid, drupal.id)

    def test_connect_button(self, cr, uid, drupal_config_id, context=None):
        try:
            dpc = self.drupal_connect(cr, uid, drupal_config_id)
            raise osv.except_osv(_('Information'), _('Connexion OK'))
        except Exception, e:
            if isinstance(e, osv.except_osv):
                raise e
            raise osv.except_osv(('Warning'), e)
        return True

drupal_connexion()
