# -*- encoding: utf-8 -*-
############################################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    Copyright (C) 2008-2009 AJM Technologies S.A. (<http://www.ajm.lu). All Rights Reserved
#    Copyright (C) 2010-2011 Thamini S.à.R.L (<http://www.thamini.com>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
############################################################################################

from osv import osv
from osv import fields

class mass_subscription_line(osv.osv_memory):
    _inherit = 'training.subscription.mass.line'

    _columns = {
        'date_session' : fields.related('session_id', 'date', type='datetime', string='Date', readonly=True),
        'exam_session_id' : fields.many2one('training.session', 'Exam Session'),
        'course_id' : fields.many2one('training.course', 'Exam',
                                      domain="[('state_course', '=', 'validated')]"),
        'no_exam': fields.related('session_id', 'offer_id', 'no_exam', type='boolean', string="No Exam", readonly=True),
    }

    def on_change_session(self, cr, uid, ids, session_id, context=None):
        if not session_id:
            return False
        session = self.pool.get('training.session').browse(cr, uid, session_id, context)
        dates = [seance.date for seance in session.seance_ids]

        result = super(mass_subscription_line, self).on_change_session(cr, uid, ids, session_id, context)
        if not result:
            result = {}

        no_exam = session.kind == 'exam' and 1 or session.offer_id.no_exam

        result.setdefault('value', {}).update({
            'kind' : session.kind,
            'date_session' : session.date,
            'exam_session_id': False,
            'course_id': False,
            'no_exam': no_exam,
        })
        result.setdefault('domain', {}).update({
            'exam_session_id' :
                [('state', 'in', ('opened_confirmed', 'opened', 'closed_confirmed')),
                 ('kind', '=', 'exam'),
                 ('date', '>', len(dates) and max(dates) or session.date),
                 ('id', '!=', session.id)],
        })
        return result

mass_subscription_line()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
