# -*- encoding: utf-8 -*-
############################################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    Copyright (C) 2008-2009 AJM Technologies S.A. (<http://www.ajm.lu). All Rights Reserved
#    Copyright (C) 2010-2011 Thamini S.à.R.L (<http://www.thamini.com>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
############################################################################################

from osv import osv
from osv import fields
import netsvc
import time
import os

class training_seance_generate_pdf_wizard(osv.osv_memory):
    _inherit = 'training.seance.generate.zip.wizard'

    _columns = {
        'exams_report' : fields.boolean('Exams', help="If you select this option, you will print the exams. The filename format is Exam_DATE_PARTICIPATIONID.pdf"),
    }

    _defaults = {
        'exams_report' : lambda *a: False,
    }

    def _get_report(self, cr, uid, oid, reportname, context=None, data=None):
        if data is None:
            data = {}
        srv = netsvc.LocalService(reportname)
        pdf, _r = srv.create(cr, uid, [oid], data, context=context)
        return pdf

    def add_selections(self, cr, uid, ids, directory, log, context=None):
        if context is None:
            context = {}
        active_id = context.get('active_id', False)
        seance = self.pool.get('training.seance').browse(cr, uid, active_id, context=context)
        ts = time.strptime(seance.date, '%Y-%m-%d %H:%M:%S')
        date = time.strftime('%Y%m%d', ts)

        exam_directory = os.path.join(directory, u'Exams')
        os.mkdir(exam_directory)

        res = []
        for obj in self.browse(cr, uid, ids, context=context):
            if obj.exams_report:
                for i, part in enumerate(seance.participant_ids):
                    if part.exam_id.forced_noquestionnaire:
                        log.errors ='ignored participation %d because related exam is marked as: forced no questionnaire\n' % (part.id)
                        continue
                    try:
                        res = self._get_report(cr, uid, part.id, 'report.training.participation.report',
                                           context=context, data={'model': 'training.participation', 'id': part.id})
                    except osv.except_osv, e:
                        log.errors += (u'Participation ID: %d got %s\n' % (part.id, e.value))
                        continue
                        #raise e

                    filename = os.path.join(exam_directory, u'Exam_%03d_%s_%s_%s_%06d.pdf' % (i, part.contact_lastname, part.contact_firstname, date, part.id))
                    fp = file(filename, 'w')
                    fp.write(res)
                    fp.close()

        return super(training_seance_generate_pdf_wizard, self).add_selections(cr, uid, ids, directory, log, context=context)

training_seance_generate_pdf_wizard()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
