##############################################################################
#
#    training_exam module for OpenERP, Training Exam
#    Copyright (C) 2010 Thamini SARL (<http://www.thamini.com>) Xavier ALT
#
#    This file is a part of training_exam
#
#    training_exam is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    training_exam is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv

class training_exam_question_group_validate(osv.osv_memory):
    _name = 'training.exam.question.group.validate.wizard'
    _description = 'Validate question by lot'
    _columns = {
    }

    def button_validate(self, cr, uid, ids, context=None):
        if context is None:
            context = {}
        question_pool = self.pool.get('training.exam.question')
        if context.get('active_ids',[]):
            question_ids = context.get('active_ids',[])
            draft_question_ids = question_pool.search(cr, uid, [('state','=','draft'),('id','in',question_ids)], context=context)
            question_pool.action_validate(cr, uid, draft_question_ids, context=context)
        return {'type': 'ir.actions.act_window_close'}

training_exam_question_group_validate()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
