# -*- coding: utf-8 -*-
##############################################################################
#
#    training_exam module for OpenERP, Training Exam
#    Copyright (C) 2010 Thamini S.à.R.L. (<http://www.thamini.com>) Xavier ALT
#
#    This file is a part of training_exam
#
#    training_exam is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    training_exam is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

import time
import netsvc
from osv import osv
from osv import fields

class training_exam_questionnaire_new_version_wizard(osv.osv_memory):
    _name = 'training.exam.questionnaire.new.version.wizard'

    _columns = {
        'note': fields.text('Note'),
    }

    def action_create_new_version(self, cr, uid, ids, context=None):
        if not ids:
            return {}
        if context is None:
            context = {}
        wizard = self.browse(cr, uid, ids[0], context=context)
        active_id = context.get('active_id', None)
        questionnaire_obj = self.pool.get('training.exam.questionnaire')
        new_id = questionnaire_obj._create_new_revision(cr, uid, active_id, context=context, note=wizard.note)
        return {
            'type': 'ir.actions.act_window',
            'res_model': 'training.exam.questionnaire',
            'res_id': new_id,
            'view_type': 'form',
            'view_mode': 'form,tree',
        }

training_exam_questionnaire_new_version_wizard()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
