# -*- encoding: utf-8 -*-
############################################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    Copyright (C) 2008-2009 AJM Technologies S.A. (<http://www.ajm.lu). All Rights Reserved
#    Copyright (C) 2010-2011 Thamini S.à.R.L (<http://www.thamini.com>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
############################################################################################

from osv import osv
from osv import fields
import netsvc

class training_exam_question_validate_wizard(osv.osv_memory):
    _name = 'training.exam.question.validate.wizard'

    _columns = {
        'questionnaire_ids': fields.many2many('training.exam.questionnaire', 'training_exam_questionnaire_question_rel', 't1', 't2', 'Questionnaires'),
        'state': fields.selection([('init', 'Init'),('validate_w_quizz', 'Validate With Quizz'),('validate_wo_quizz', 'Validate Without Quizz')], 'State'),
    }

    def default_get(self, cr, uid, fields_list, context=None):
        """ force validation of supplied question (active_id) before returning default value.
            In case the question isn't valid, _check_answer will raise and error, forcing
            user to correct the question before showing the validation window.
        """
        if context is None:
            context = {}
        current_question_id = context.get('active_id')
        if current_question_id:
            self.pool.get('training.exam.question')._check_answer(cr, uid, [current_question_id], context=context)
        return super(training_exam_question_validate_wizard, self).default_get(cr, uid, fields_list, context=context)

    def _has_questionnaire_validated(self, cr, uid, question_id, context=None):
        qz_pool = self.pool.get('training.exam.questionnaire')
        if not question_id:
            return []

        cr.execute("""
            SELECT teqq.questionnaire_id
            FROM training_exam_questionnaire_question teqq
            LEFT JOIN training_exam_question teqn ON (teqq.question_id = teqn.id)
            WHERE teqq.questionnaire_id IN (
                        SELECT distinct(questionnaire_id)
                        FROM training_exam_questionnaire_question teqq
                        WHERE teqq.question_id = %(qid)s)
            GROUP BY teqq.questionnaire_id
            HAVING count(teqn.id) - 1 = sum(CASE WHEN (teqn.state = 'validated' AND teqn.id != %(qid)s) THEN 1 ELSE 0 END)
        """, {'qid': question_id})

        qz_ids = [ x[0] for x in cr.fetchall() ]
        return qz_ids

    def _get_default_state(self, cr, uid, context=None):
        if context is None:
            context = {}
        ids = self._has_questionnaire_validated(cr, uid, context.get('active_id'), context=context)
        if not ids:
            return 'validate_wo_quizz'
        return 'validate_w_quizz'

    def _get_default_questionnaire(self, cr, uid, context=None):
        if context is None:
            context = {}
        return self._has_questionnaire_validated(cr, uid, context.get('active_id'), context=context)

    def action_validate_wo_qz(self, cr, uid, ids, context=None):
        if context is None:
            context = {}
        if context.get('active_id'):
            self.pool.get('training.exam.question').action_validate(cr, uid, [context.get('active_id')], context=context)
        return {'type': 'ir.actions.act_window_close'}

    def action_validate_w_qz(self, cr, uid, ids, context=None):
        if context is None:
            context = {}
        wkf = netsvc.LocalService('workflow')
        if context.get('active_id'):
            self.pool.get('training.exam.question').action_validate(cr, uid, [context.get('active_id')], context=context)
            for qwiz in self.browse(cr, uid, ids, context=context):
                for qz in qwiz.questionnaire_ids:
                    wkf.trg_validate(uid, 'training.exam.questionnaire', qz.id, 'signal_teq_validate', cr)
        return {'type': 'ir.actions.act_window_close'}

    _defaults = {
        'state': _get_default_state,
        'questionnaire_ids': _get_default_questionnaire,
    }

training_exam_question_validate_wizard()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
