# -*- encoding: utf-8 -*-
############################################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    Copyright (C) 2008-2009 AJM Technologies S.A. (<http://www.ajm.lu). All Rights Reserved
#    Copyright (C) 2010-2011 Thamini S.à.R.L (<http://www.thamini.com>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
############################################################################################

from osv import osv
from osv import fields

class training_exam_question_assign_course(osv.osv_memory):
    _name = 'training.exam.question.assign.course'
    _columns = {
        'course_id': fields.many2one('training.course', 'Course', domain="[('state_course','=','validated')]",  required=True),
    }

    def action_confirm(self, cr, uid, ids, context=None):
        if context is None:
            context = {}
        proxy = self.pool.get('training.exam.question')
        for assign_course in self.browse(cr, uid, ids, context):
            for question in proxy.browse(cr, uid, context.get('active_ids',[]), context=context):
                course_ids = set([assign_course.course_id.id] + [course.id for course in question.course_ids])
                question.write({'course_ids' : [(6, 0, list(course_ids))]})
        return {'type': 'ir.actions.act_window_close'}


training_exam_question_assign_course()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
