# -*- encoding: utf-8 -*-
############################################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    Copyright (C) 2008-2009 AJM Technologies S.A. (<http://www.ajm.lu). All Rights Reserved
#    Copyright (C) 2010-2011 Thamini S.à.R.L (<http://www.thamini.com>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
############################################################################################

from osv import osv
from osv import fields

class training_question_wizard(osv.osv_memory):
    _name = 'training.exam.question.wizard'
    _description = 'Question Wizard'

    _columns = {
        'course_id' : fields.many2one('training.course', 'Course', required=True, domain="[('state_course', '=', 'validated')]"),
    }


    def find_question_with_course(self, cr, uid, ids, context=None):
        if not ids:
            return {}
        if context is None:
            context = {}
        this = self.browse(cr, uid, ids, context=context)[0]
        context2 = context.copy()
        context2.update({'course_id':this.course_id.id})

        return {
            'view_type': 'form',
            "view_mode": 'form',
            'res_model': 'training.exam.question',
            'view_id':self.pool.get('ir.ui.view').search(cr,uid,[('name','=','training.exam.question.tree')]),
            'type': 'ir.actions.act_window',
            'target':'current',
            'context': context2,
        }

training_question_wizard()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
