# -*- coding: utf-8 -*-
# Copyright 2010 Thamini S.à.R.L    This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

from osv import osv
from osv import fields

class training_exam_question_group_deprecate(osv.osv_memory):
    _name = 'training.exam.question.group.deprecate.wizard'
    _description = 'Deprecate question by lot'
    _columns = {
        'note': fields.text('Note'),
    }

    def button_deprecate(self, cr, uid, ids, context=None):
        if not ids:
            return {}
        if context is None:
            context = {}
        question_pool = self.pool.get('training.exam.question')
        if context.get('active_ids',[]):
            wizard = self.browse(cr, uid, ids[0], context=context)
            question_ids = context.get('active_ids', [])
            validated_question_ids = question_pool.search(cr, uid, [('state','in',['validated','draft']),('id','in',question_ids)], context=context)

            if wizard.note:
                context = context.copy()
                context['_deprecated_note'] = wizard.note

            question_pool.action_deprecate(cr, uid, validated_question_ids, context=context)
        return {'type': 'ir.actions.act_window_close'}

training_exam_question_group_deprecate()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4: