# -*- encoding: utf-8 -*-
############################################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    Copyright (C) 2008-2009 AJM Technologies S.A. (<http://www.ajm.lu). All Rights Reserved
#    Copyright (C) 2010-2011 Thamini S.à.R.L (<http://www.thamini.com>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
############################################################################################

from osv import osv
from osv import fields

class exam_wizard_helper(osv.osv_memory):
    _name = 'training.exam.wizard.helper'

    _columns = {
        'questionnaire_id' : fields.many2one('training.exam.questionnaire', 'Questionnaire', required=True, select=1),
        'question_ids' : fields.many2many('training.exam.question', 'training_exam_wizard_helper_rel', 'helper_id', 'question_id', 'Questions', ),
        'course_id' : fields.many2one('training.course', 'Course', context={'quizz_search': 1}),
        'kind' : fields.char('Kind', size=32),
    }

    def default_get(self, cr, uid, fields_list, context=None):
        #This wizard open click on button in training.exam.questionnaire so some default_* key exist in context. here remove the key starts with default_ in context
        #May be this problem fix on client side. if any form open on button click then remove the context key starts with default_*
        if context is None:
            context = {}
        for key in context.keys():
            if key.startswith('default_'):
                del context[key]
        return super(exam_wizard_helper, self).default_get(cr, uid, fields_list, context=context)

    def _default_questionnaire_id(self, cr, uid, context=None):
        if context is None:
            context = {}
        return context.get('active_id', False)

    def _default_course_id(self, cr, uid, context=None):
        if context is None:
            context = {}
        active_id = context.get('active_id', False)
        result = False
        if context.get('active_model', False) == 'training.exam.questionnaire':
            questionnaire = self.pool.get('training.exam.questionnaire').browse(cr, uid, active_id, context=context)
            if questionnaire.type == 'examen':
                result = questionnaire.main_course_id.id
            else:
                result = len(questionnaire.course_ids) and questionnaire.course_ids[0].course_id.id or None
        return result

    _defaults = {
        'questionnaire_id' : _default_questionnaire_id,
        'course_id' : _default_course_id,
    }

    def add_questions_cb(self, cr, uid, ids, context=None):
        if not ids:
            return False
        this = self.browse(cr, uid, ids[0], context=context)

        proxy = self.pool.get('training.exam.questionnaire.question')

        # get current and next sequence number (to keep question ordering)
        cr.execute(
        """SELECT max(sequence)
           FROM training_exam_questionnaire_question
           WHERE questionnaire_id = %s""",
           (int(this.questionnaire_id.id),)
        )
        current_sequence = cr.fetchone()
        next_sequence = 0
        if current_sequence:
            next_sequence = (current_sequence[0] or 0) + 1

        for idx, question in enumerate(this.question_ids):
            proxy.create(cr, uid,
                         {
                             'sequence': next_sequence + idx,
                             'question_id' : question.id,
                             'questionnaire_id' : this.questionnaire_id.id,
                         }, context=context)

        return {'type' : 'ir.actions.act_window_close'}

exam_wizard_helper()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
