# -*- encoding: utf-8 -*-
##############################################################################
#
#    training_exam module for OpenERP, Training Exam Management
#    Copyright (C) 2010 Thamini S.à.R.L (<http://www.thamini.com>) Xavier ALT
#
#    This file is a part of training
#
#    training is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    training is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv
from osv import fields
from training.training_content_review import content_review_type

content_review_type.insert(2, ('exam_material', 'Exam Material'))

class training_content_review(osv.osv):
    _inherit = 'training.content.review'

    def _seance_next_date_query_get(self, cr, uid, review_record, context=None):
        """
        Return the SQL query to get the next seance
        date for the current 'review_record' object
        @return string (the SQL query with)
        """
        if review_record.reason_id.type == 'exam_material':
            return """
                SELECT tcr.id,min(tsea.date) AS min_ready_date
                FROM training_content_review tcr
                LEFT JOIN training_content_review_reason tcrr ON (tcr.reason_id = tcrr.id)
                LEFT JOIN training_content_review_line tcrl ON (tcrl.review_id = tcr.id)
                LEFT JOIN training_exam_question teq ON (tcrl.question_id = teq.id)
                LEFT JOIN training_exam_questionnaire_question teqq ON (teqq.question_id = teq.id)
                LEFT JOIN training_exam_questionnaire teqz ON (teqq.questionnaire_id = teqz.id)
                LEFT JOIN training_participation tp ON (tp.questionnaire_id = teqz.id AND tp.date >= %s)
                LEFT JOIN training_seance tsea ON (tp.seance_id = tsea.id)
                WHERE tcrr.type = 'exam_material'
                  AND tcr.id = %s GROUP BY tcr.id
                """
        return super(training_content_review, self)._seance_next_date_query_get(cr, uid, review_record, context=context)

training_content_review()

class training_content_review_line(osv.osv):
    _inherit = 'training.content.review.line'

    def _get_document_name_by_type(self, cr, uid, review_line, context=None):
        if review_line.review_id.type == 'exam_material':
            return review_line.question_id.name_get()[0][1]
        return super(training_content_review_line, self)._get_document_name_by_type(cr, uid, review_line, context=context)

    _columns = {
        'question_id': fields.many2one('training.exam.question', 'Question'),
    }

training_content_review_line()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
