# -*- coding: utf-8 -*-
# Copyright 2010 Thamini S.à.R.L    This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

from report import report_sxw

class training_seance_exam_followup_list(report_sxw.rml_parse):
    def __init__(self, cr, uid, name, context):
        super(training_seance_exam_followup_list, self).__init__(cr, uid, name, context=context)
        self.localcontext.update({
            '_': self._translate,
            'ordered_participants': self.ordered_participants,
        })

    def repeatIn(self, lst, name, nodes_parent=False):
        """improved version"""
        for e in lst:
            yield {name: e}

    def ordered_participants(self, seance):
        participants = list(seance.participant_ids)
        participants.sort(key=lambda p: (p.contact_id.name, p.contact_id.first_name))
        for participant in participants:
            yield participant

report_sxw.report_sxw('report.training.seance.exam.followup.list.report',
                       'training.seance',
                      'addons/training_exam/report/training_seance_exam_followup_list.rml',
                      parser=training_seance_exam_followup_list,
                      header=False)
