# -*- coding: utf-8 -*-
# Copyright 2010 Thamini S.à.R.L    This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

from report import report_sxw

class training_participation_exam_result_firstpage(report_sxw.rml_parse):
    def __init__(self, cr, uid, name, context):
        super(training_participation_exam_result_firstpage, self).__init__(cr, uid, name, context)
        self.localcontext.update({
            'is_private_person': self.is_private_person,
        })

    def is_private_person(self, participation):
        state = False # Default, don't change previous behaviour
        if not participation:
            return state
        if not participation.partner_id:
            return state
        if not participation.partner_id.notif_contact_id:
            return state

        partner_name = participation.partner_id.name.split()
        contact = participation.partner_id.notif_contact_id.contact_id
        first_name = contact.first_name and contact.first_name or ''
        contact_name = first_name.split() + contact.name.split()
        contact_name_rev = contact.name.split() + first_name.split()

        def compare_names(x, y):
            if len(x) <> len(y):
                return False
            for k in range(len(x)):
                if x[k] <> y[k]:
                    return False
            return True # all identicals

        return compare_names(partner_name, contact_name) or \
               compare_names(partner_name, contact_name_rev)

report_sxw.report_sxw('report.training.participation.exam.result.firstpage',
                      'training.participation',
                      'addons/training_exam/report/training_exam_result_firstpage.rml',
                      parser=training_participation_exam_result_firstpage,
                      header=True)
