# -*- coding: utf-8 -*-
# Copyright 2010 Thamini S.à.R.L    This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

import pooler
from report import report_sxw

class training_participation_exam_result(report_sxw.rml_parse):
    def __init__(self, cr, uid, name, context):
        super(training_participation_exam_result, self).__init__(cr, uid, name, context)
        self.localcontext.update({
            'is_partner_firstpage': self.is_partner_firstpage,
        })
        self.partner_firstpage_dict = {}
        self._cr = cr

    def is_partner_firstpage(self, participation):

        p_id = participation.partner_id.id
        if p_id not in self.partner_firstpage_dict:
            self.partner_firstpage_dict[p_id] = participation.id

        if participation.id == self.partner_firstpage_dict[p_id]:
            return True
        return False

class report_sxw_exam_result_custom(report_sxw.report_sxw):
    def getObjects(self, cr, uid, ids, context):
        """
        Result ids order by contact.name, contact.first_name for each group of reports
        """
        table_obj = pooler.get_pool(cr.dbname).get(self.table)

        cr.execute("""
            SELECT
                tp.id
            FROM
                res_partner_contact rpc,
                training_participation tp,
                training_subscription_line tsl,
                res_partner_job rpj
            WHERE
                    tp.subscription_line_id = tsl.id
                AND tsl.job_id = rpj.id
                AND rpj.contact_id = rpc.id
                AND tp.id in (%s)
            ORDER BY
                rpc.name, rpc.first_name
        """ % ','.join(map(str, map(int, ids))))
        sorted_ids = [ x[0] for x in cr.fetchall() ]

        return table_obj.browse(cr, uid, sorted_ids, list_class=report_sxw.browse_record_list,
                                context=context, fields_process=report_sxw._fields_process)

#report_sxw.report_sxw('report.training.participation.exam.result',
report_sxw_exam_result_custom('report.training.participation.exam.result',
                      'training.participation',
                      'addons/training_exam/report/training_exam_result.rml',
                      parser=training_participation_exam_result,
                      header=True)
