# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

import wizard
import pooler
import time
import tools
from tools.translate import _
from osv import osv
from osv import fields

class training_session_create_wizard(osv.osv_memory):
    _name = 'training.session.create.wizard'

    _columns = {
        'date': fields.datetime('Date', required=True),
        'name': fields.char('Name', size=64, required=True),
    }

    def _default_get_name(self, cr, uid, context=None):
        if context is None:
            return ''
        active_id = context.get('active_id')
        if not active_id:
            return ''
        offer = self.pool.get('training.offer').browse(cr, uid, active_id, context=context)
        return offer.name

    _defaults = {
        'date': lambda *a: time.strftime('%Y-%m-%d 08:30:00'),
        'name': _default_get_name,
    }

    def _get_new_session_data(self, cr, uid, wizard, context=None):
        if context is None:
            context = {}
        session_proxy = self.pool.get('training.session')
        active_id = context.get('active_id') or None
        vals = session_proxy.on_change_offer(cr, uid, None, active_id)
        if isinstance(vals, dict):
            # we have specified a custom name on session creation,
            # don't let on_change overwrite it now.
            vals.setdefault('value', {}).pop('name', None)
        resdict = vals['value']
        resdict.update({
            'offer_id' : active_id,
            'date' : wizard.date,
            'name' : "%s (%s)" % (wizard.name, time.strftime("%Y-%m-%d", time.strptime(wizard.date, '%Y-%m-%d %H:%M:%S'))),
        })
        return resdict

    def create_session(self, cr, uid, ids, context=None):
        """ create a new session based on the active offer
            (this does not work with multiple resources!
        """
        if not context or not ids:
            raise osv.except_osv(_('Error'), _('Context not defined'))
        if context is None:
            context = {}
        wizard = self.browse(cr, uid, ids[0], context=context)

        active_id = context.get('active_id')
        if not active_id:
            raise osv.except_osv(_('Warning'), _('Please select an offer to planify'))

        proxy = self.pool.get('training.offer')
        offer = proxy.browse(cr, uid, active_id, context=context)
        if not offer.can_be_planned:
            raise osv.except_osv(_('Warning'),
                                 _("You can not create a session with a non-validated offer"))

        session_proxy = self.pool.get('training.session')
        session_data = self._get_new_session_data(cr, uid, wizard, context=context)
        session_id = session_proxy.create(cr, uid, session_data, context=context)

        return {
            'view_type': 'form',
            "view_mode": 'form',
            'res_model': 'training.session',
            'view_id': self.pool.get('ir.ui.view').search(cr,uid,[('name','=','training.session.form')]),
            'type': 'ir.actions.act_window',
            'target': 'current',
            'res_id' : int(session_id),
        }

training_session_create_wizard()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
