# -*- coding: utf-8 -*-
# Copyright 2012 Thamini S.à.R.L    This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

from osv import osv
from osv import fields
import decimal_precision as dp

class training_subscription_line_modify_price_wizard(osv.osv_memory):
    """This wizard allow to change price of a subscription line even when it's confirmed
    """
    _name = 'training.subscription.line.modify.price.wizard'
    _columns = {
        'price': fields.float('Price', digits_compute=dp.get_precision('Account'), required=True),
    }

    def _get_default_price(self, cr, uid, context=None):
        if context is None:
            return 0.0
        if context.get('active_id'):
            subscription_line_obj = self.pool.get('training.subscription.line')
            return subscription_line_obj.browse(cr, uid, context['active_id'], context=context).price

    _defaults = {
        'price': _get_default_price,
    }

    def button_modify_price(self, cr, uid, ids, context=None):
        if not (ids and context is not None):
            return {}
        wizard_id = ids[0]
        wizard = self.browse(cr, uid, wizard_id, context=context)
        active_id = context['active_id']

        subscription_line_obj = self.pool.get('training.subscription.line')
        subscription_line_obj.write(cr, uid, [active_id], {'price': wizard.price}, context=context)
        return {}

training_subscription_line_modify_price_wizard()
