# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv
from osv import fields
from tools.translate import _
import netsvc

class training_create_offer(osv.osv_memory):
    _name = 'training.create.offer'
    _columns ={
        'name': fields.char('Name', size=64),
    }

    def default_get(self, cr, uid, fields, context=None):
        if context is None:
            context = {}

        if context.get('active_ids'):
            course_obj = self.pool.get('training.course')
            for course in course_obj.browse(cr, uid, context['active_ids'], context=context):
                if course.state_course != 'validated':
                    raise osv.except_osv(_('Error'),_("You can only create an offer based on validated courses"))

        return {}

    def create_offers(self, cr, uid, ids, context=None):
        if context is None:
            context = {}
        if not context.get('active_ids'):
            return {}

        course_obj = self.pool.get('training.course')
        course_offer_obj = self.pool.get('training.course.offer.rel')
        offer_obj = self.pool.get('training.offer')
        offer_ids = []
        for course in course_obj.browse(cr, uid, context['active_ids'], context=context):
            if course.state_course == 'validated':
                offer_id = offer_obj.create(cr, uid, {
                                'name' : course.name,
                                'lang_id' : course.lang_id.id,
                                'type_id' : course.course_type_id.id,
                                'product_line_id': course.category_id.id,
                            }, context=context)

                course_offer_obj.create(cr, uid, {'offer_id' : offer_id, 'course_id' : course.id}, context=context)
                offer_ids.append(offer_id)

        number_of_offers = len(offer_ids)
        if not number_of_offers:
            return {}
        elif number_of_offers == 1:
            return {
                'res_id' : int(offer_ids[0]),
                'name' : 'Offers',
                'view_type' : 'form',
                'view_mode' : 'form,tree',
                'res_model' : 'training.offer',
                'view_id' : False,
                'type' : 'ir.actions.act_window',
            }
        else:
            return {
                'domain' : "[('id', 'in', [%s])]" % ','.join(map(str,offer_ids)),
                'name' : 'Offers',
                'view_type' : 'form',
                'view_mode' : 'tree,form',
                'res_model' : 'training.offer',
                'view_id' : False,
                'type' : 'ir.actions.act_window',
            }

training_create_offer()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
