# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv
from osv import fields
from tools.translate import _

class training_create_block_offer(osv.osv_memory):
    _name = 'training.create.block.offer'
    _columns = {
        'name' : fields.char('Name', size=64, required=True),
        'type_id' : fields.many2one('training.course_type', 'Type', required=True,),
        'lang_id' : fields.many2one('res.lang', 'Language', required=True,),
        'product_line_id' : fields.many2one('training.course_category', 'Product Line', select=1, required=True),
    }

    def default_get(self, cr, uid, fields, context=None):
        if context is None:
            context = {}
        if not context.get('active_model'):
            return {}
        if not context.get('active_ids'):
            return {}

        active_obj = self.pool.get(context['active_model'])
        active_ids = context['active_ids']
        languages = set()
        result = {}
        for course in active_obj.browse(cr, uid, active_ids, context=context):
            if course.state_course != 'validated':
                raise osv.except_osv(_('Warning'), _("Please, The state of all courses must be 'validated'"))
            if result.get('name') is None:
                result['name'] = course.name
            result.update({
                'product_line_id': course.category_id and course.category_id.id or False,
                'type_id': course.course_type_id and course.course_type_id.id or False
            })
            languages.add(course.lang_id.id)

        if len(languages) > 1:
            raise osv.except_osv(_('Warning'), _('You have selected a course with a different language'))

        result['lang_id'] = list(languages)[0]
        return result


    def create_block_offer(self, cr, uid, ids, context=None):
        if context is None:
            context = {}
        if not context.get('active_model'):
            return {}
        if not context.get('active_ids'):
            return {}
        if not ids:
            return {}

        offer_obj = self.pool.get('training.offer')
        course_offer_obj = self.pool.get('training.course.offer.rel')

        active_model = context['active_model']
        active_obj = self.pool.get(active_model)
        wizard = self.browse(cr, uid, ids[0], context=context)
        offer_id = offer_obj.create(cr, uid, {
                            'name': wizard.name,
                            'lang_id': wizard.lang_id.id,
                            'type_id': wizard.type_id.id,
                            'product_line_id': wizard.product_line_id.id,
                    }, context=context)

        for course in active_obj.browse(cr, uid, context['active_ids'], context=context):
            if course.lang_id.id != wizard.lang_id.id:
                raise osv.except_osv(_('Warning'), _("Please, You have selected a course with a different language"))
            course_offer_obj.create(cr, uid, {'course_id': course.id, 'offer_id': offer_id}, context=context)
        offer_obj.write(cr, uid, [offer_id], {'name' : wizard.name}, context=context)

        return {
            'res_id' : int(offer_id),
            'name' : 'Offers',
            'view_type' : 'form',
            'view_mode' : 'form,tree',
            'res_model' : 'training.offer',
            'view_id' : False,
            'type' : 'ir.actions.act_window',
        }


training_create_block_offer()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
