# -*- encoding: utf-8 -*-
############################################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    Copyright (C) 2008-2009 AJM Technologies S.A. (<http://www.ajm.lu). All Rights Reserved
#    Copyright (C) 2010-2011 Thamini S.à.R.L (<http://www.thamini.com>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
############################################################################################

from report import report_sxw

class training_seance_support_delivery_report(report_sxw.rml_parse):
    def __init__(self, cr, uid, name, context):
        super(training_seance_support_delivery_report, self).__init__(cr, uid, name, context=context)
        self.localcontext.update({
            'list_seances': self.list_seances,
            'list_pl': self.list_pl,
            'additional_info': self.additional_info,
        })

    def _is_valid(self, product):
        partner = self.localcontext.get('partner', None)
        if not partner:
            # no partner given ? ok, we list all, allowing the report to be usable by normal users
            return True

        return any(seller.name == partner for seller in product.seller_ids)

    def repeatIn(self, lst, name, nodes_parent=False):
        """improved version"""
        for e in lst:
            yield {name: e}

    def list_seances(self):
        seances = self.localcontext['objects']
        for seance in seances:
            if any(self._is_valid(pl.product_id) for pl in seance.purchase_line_ids):
                yield seance

    def list_pl(self, seance):
        for pl in seance.purchase_line_ids:
            if self._is_valid(pl.product_id):
                yield pl

    def additional_info(self, pl):
        r = ''
        attach = pl.attachment_id
        if attach and attch.type == 'course_material':
            r = 'Attachment Name: %s' % (attach.name,)
            for component in attach.component_ids:
                if self._is_valid(component.product_id):
                    r += "\n\t%s\t%s" % (component.product_qty, component.product_id.name)

        return r


report_sxw.report_sxw('report.training.seance.support.delivery.report',
                      'training.seance',
                      'addons/training/report/delivery_support.rml',
                      parser=training_seance_support_delivery_report,
                      header=True)

class training_seance_presence_list(report_sxw.rml_parse):
    def __init__(self, cr, uid, name, context):
        super(training_seance_presence_list, self).__init__(cr, uid, name, context=context)
        self.localcontext.update({
            '_': self._translate,
            'ordered_participants': self.ordered_participants,
            'ordered_participants_noshow': self.ordered_participants_noshow,
            'get_participants_noshow_count': self.get_participants_noshow_count,
        })

    def repeatIn(self, lst, name, nodes_parent=False):
        """improved version"""
        for e in lst:
            yield {name: e}

    def _get_participants_cache(self, seance, participants):
        participant_obj = seance.pool.get('training.participation')
        participant_cache_fields = ['partner_id', 'course_questionnaire_id']
        participant_ids = [ p.id for p in participants ]
        participants_cache = dict(((x['id'], x) for x in participant_obj.read(self.cr, self.uid, participant_ids, participant_cache_fields)))
        return participants_cache

    def ordered_participants(self, seance):
        participants = list(seance.participant_ids)
        participants.sort(key=lambda p: (p.contact_id.name, p.contact_id.first_name))
        participants_cache = self._get_participants_cache(seance, participants)
        for participant in participants:
            participant._cache = participants_cache.get(participant.id, {})
            yield participant

    def ordered_participants_noshow(self, seance):
        participants = list(seance.participant_ids)
        participants.sort(key=lambda p: (p.contact_id.name, p.contact_id.first_name))
        participants_cache = self._get_participants_cache(seance, participants)
        for participant in participants:
            participant._cache = participants_cache.get(participant.id, {})
            if not participant.present:
                yield participant

    def get_participants_noshow_count(self, seance):
        return reduce(lambda acc, a: acc + (not a.present and 1 or 0),
                      seance.participant_ids,
                      0)

report_sxw.report_sxw('report.training.seance.presence.report',
                       'training.seance',
                      'addons/training/report/training_presencelist.rml',
                      parser=training_seance_presence_list,
                      header=True)

report_sxw.report_sxw('report.training.seance.presence.noshow',
                       'training.seance',
                      'addons/training/report/training_presence_noshow.rml',
                      parser=training_seance_presence_list,
                      header=True)

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:

