# -*- coding: utf-8 -*-
##############################################################################
#
#    training module for OpenERP, Training Management
#    Copyright (C) 2010 Thamini S.à.R.L (<http://www.thamini.com>) Xavier ALT
#
#    This file is a part of training
#
#    training is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    training is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv
from osv import fields
from tools.translate import _

def _get_product_procurement_methods(self, cr, uid, context=None):
    return [
        ('by_subscription', _('By Subscription')),
        ('fix', _('Fix')),
    ]

def _get_product_procurement_price_compute(self, cr, uid, context=None):
    return [
        ('from_attachment', _('From Attachment')),
        ('from_product', _('From Product')),
    ]

def _get_product_procurement_trigger(self, cr, uid, context=None):
    return [
        ('on_first_seance', _('On First Seance')),
        ('on_all_seances', _('On All Seances')),
        ('on_seance_course', _('Relative to the course')),
        ('on_last_seance', _('On Last Seance')),
    ]

class product_product_training(osv.osv):
    _inherit = 'product.product'

    _columns = {
        'procurement_trigger': fields.selection(_get_product_procurement_trigger, 'Procurement Trigger', required=True,
                                              help="Define default trigger for this procurement"),
        'procurement_method': fields.selection(_get_product_procurement_methods, 'Procurement Method', required=True,
                                              help="Procurement quantity will be computed using this method"),
        'procurement_price': fields.selection(_get_product_procurement_price_compute, 'Procurement Price', required=True,
                                              help="From where will the real procurement price come. "
                                                   "If 'From Attachment' is choosen and no attachment is specified, "
                                                   "the system will use product price as fallback"),
    }

    _defaults = {
        'procurement_trigger': lambda *a: 'on_first_seance',
        'procurement_method': lambda *a: 'fix',
        'procurement_price': lambda *a: 'from_product',
    }

product_product_training()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
