from osv import osv
from osv import fields
from tools.translate import _

import netsvc
import time

class account_invoice(osv.osv):
    _inherit = 'account.invoice'

    _columns = {
        'send_to': fields.char('Email', size=128),
        'sent_by_mail': fields.boolean('Sent By Mail', readonly=True, select=2),
        'sent_by_mail_at': fields.datetime('Sent At', readonly=True),
        'send_manually': fields.boolean('Send Manually', helps='Activate this field to indicated that the invoice will be send manually, i.e. not automatically by cron'),
        'invoice_line': fields.one2many('account.invoice.line', 'invoice_id', 'Invoice Lines', readonly=True, states={'draft':[('readonly',False)]}, select=1),
    }

    def copy_data(self, cr, uid, id, default=None, context=None):
        data = super(account_invoice, self).copy_data(cr, uid, id, default=default, context=context)
        if data:
            for k in ['send_to', 'sent_by_mail', 'sent_by_mail_at', 'send_manually']:
                data.pop(k, None)
        return data

    def onchange_partner_id(self, cr, uid, ids, type, partner_id, date_invoice=False, payment_term=False, partner_bank=False, company_id=False):
        values = super(account_invoice, self).onchange_partner_id(cr, uid, ids, type, partner_id, date_invoice, payment_term, partner_bank, company_id)

        if partner_id:
            partner = self.pool.get('res.partner').browse(cr, uid, partner_id)

            invoice_email = False
            default_email = False

            for address in partner.address:
                if address.type == 'default' and address.email:
                    default_email = address.email
                if address.type == 'invoice' and address.email:
                    invoice_email = address.email

            if invoice_email or default_email:
                values.setdefault('value', {})['send_to'] = invoice_email and invoice_email or default_email
        else:
            values.setdefault('value', {})['send_to'] = False

        return values

    def action_workflow_send_email(self, cr, uid, ids, context=None):
        srv = netsvc.LocalService('report.account.invoice')
        email_obj = self.pool.get('training.email')
        for invoice in self.browse(cr, uid, ids, context=context):
            if invoice.send_to and invoice.type == 'out_invoice':
                pdf, _r = srv.create(cr, uid, [invoice.id], {}, context=context)
                if pdf:
                    filename = "Invoice_%s.pdf" % (invoice.name.replace('/', '_'))
                    sent = email_obj.send_email(cr, uid, 'invoice', 'a', to=invoice.send_to, attachments=[(filename, pdf),], context=context, invoice=invoice)
                    invoice.write({'sent_by_mail': sent,
                                   'sent_by_mail_at': time.strftime('%Y-%m-%d %H%M%S'),
                                  }, context=context)
        return True

account_invoice()

class   purchase_order_analytic_distribution(osv.osv):
    _inherit = 'purchase.order'

    def inv_line_create(self, cr, uid, a, ol):
        proxy_journal = self.pool.get('account.journal')
        proxy_adist = self.pool.get('account.analytic.plan.instance')

        adist_id = False
        fpos_obj = self.pool.get('account.fiscal.position')
        fpos = ol.order_id.fiscal_position or False

        if ol.analytics_id:
            adist_id = ol.analytics_id.id
        elif ol.account_analytic_id:
            # if product line use standard 'account_analytic_id' field, force
            # convertion to real account.analytic.plan.instance
            purchase_journal = proxy_journal._get_journal_record_by_type(cr, uid, 'purchase')
            if not purchase_journal.analytic_journal_id:
                raise osv.except_osv(_('Error'), _('Accounting journal "%s" have no analytic journal') % (purchase_journal.name,))
            adist_id = proxy_adist.create(cr, uid, {
                'journal_id': purchase_journal.analytic_journal_id.id,
                'account_ids': [
                    (0, 0, {'analytic_account_id': ol.account_analytic_id.id, 'rate': 100.0}),
                ]
            })

        return (0, False, {
            'name': ol.name,
            'account_id': a,
            'price_unit': ol.price_unit or 0.0,
            'quantity': ol.product_qty,
            'product_id': ol.product_id.id or False,
            'uos_id': ol.product_uom.id or False,
            'invoice_line_tax_id': [(6, 0, fpos_obj.map_tax(cr, uid, fpos, ol.taxes_id))],
            'analytics_id': adist_id or False,
        })
purchase_order_analytic_distribution()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
