# -*- coding: utf-8 -*-
# Copyright 2011 Thamini S.à.R.L    This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

from osv import osv
from osv import fields
from tools.translate import _

class account_journal(osv.osv):
    _inherit = 'account.journal'

    def _get_journal_id_by_type(self, cr, uid, type='sale', refund=False, context=None):
        assert type in ('sale', 'purchase')
        if refund:
            type += '_refund'
        journal_ids = self.search(cr, uid, [('type','=',type)], context=context)
        if not journal_ids:
            raise osv.except_osv(_('Error !'), _("No journal of type '%s' found, please check that at least one exist") % (type))
        return journal_ids[0]

    def _get_journal_record_by_type(self, cr, uid, type='sale', refund=False, context=None):
        assert type in ('sale', 'purchase')
        journal_id = self._get_journal_id_by_type(cr, uid, type, refund, context)
        return self.browse(cr, uid, journal_id, context=context)

account_journal()
