# -*- encoding: utf-8 -*-
############################################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    Copyright (C) 2008-2009 AJM Technologies S.A. (<http://www.ajm.lu). All Rights Reserved
#    Copyright (C) 2010-2011 Thamini S.à.R.L (<http://www.thamini.com>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
############################################################################################

{
    'name' : 'Training Management',
    'version' : '0.6',
    'author' : 'Tiny SPRL - Thamini S.à.R.L',
    'website' : 'http://www.openerp.com',
    'description' : """
From the conception of a project to the elaboration of your catalog, our training management allows you to create easily courses and to organize the sessions.
With the analytic account support, you can know the costs of your trainings.

* Manage the subscriptions
* Manage the courses
* Manage the offers (for a planning)
* Manage the sessions
* Manage the support of course
""",
    'depends' : [
        'base',
        'core_config',
        'base_contact_team',
        'decimal_precision',
        'base_iban',
        'account',
        'account_payment',
        'purchase',
        'purchase_analytic_plans',
        'product',
        'mrp',
        'smtpclient',
        'product',
        'sale',
        'document',
        'document_type',
        'procurement',
        'account_analytic_plans',
    ],
    'init_xml' : [
        'training_sequence.xml',
        'training_data.xml',
    ],
    'demo_xml' : [
        'demo/training_course_type.xml',
        'demo/training_course_category.xml',
        'demo/training_course_theme.xml',
        'demo/training_course.xml',
        'demo/training_offer.xml',
        'demo/training_catalog.xml',
        'demo/training_session.xml',
#        'demo/training_seance.xml',
    ],
    'update_xml' : [
        'training_config.xml',
        'security/training_security.xml',
        'security/roles.xml',
        'security/ir.model.access.csv',
        'wizard/training_subscription_session.xml',
        'wizard/validate_course_view.xml',
        'wizard/training_subscription_line_confirm.xml',
        'wizard/training_subscription_line_modify_price_view.xml',
        'wizard/training_create_offer.xml',
        'wizard/training_create_block_offer.xml',
        'wizard/training_subscription_second_line.xml',


        # TODO move this into the base_contact module
        'contact_security/groups.xml',
        'contact_security/ir.model.access.csv',

        'document_type_data.xml',
        'product_view.xml',
        'purchase_view.xml',
        'partner_view.xml',
        'base_contact_view.xml',
        'training_view.xml',
        'training_content_review_view.xml',
        'wizard/wizard_create_session_view.xml',
        'invoice_view.xml',
        'training_report.xml',
        'workflow/catalog.xml',
        'workflow/course.xml',
        'workflow/offer.xml',
        'workflow/seance.xml',
        'workflow/session.xml',
        'workflow/subscription.xml',
        'workflow/subscription_line.xml',
        'workflow/participation_sh_request.xml',
        'workflow/participation_sh.xml',
        'workflow/invoice.xml',
        'workflow/training_content_review.xml',
        'training_email_view.xml',
        'training_holiday_view.xml',
        'document_price_view.xml',
    ],
    'test': [
        'test/training_util.yml',
        'test/training_holiday.yml',
        'test/training_purchase.yml',
        'test/training_course_support.yml',
        'test/training.yml',
    ],
    'active' : False,
    'installable' : True,
    'certificate': '00911593900947386733',
}

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
