# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

import time

from report import report_sxw
from common_report_header import common_report_header

class account_balance(report_sxw.rml_parse, common_report_header):
    _name = 'report.account.account.balance'

    def __init__(self, cr, uid, name, context=None):
        super(account_balance, self).__init__(cr, uid, name, context=context)
        self.sum_debit = 0.00
        self.sum_credit = 0.00
        self.date_lst = []
        self.date_lst_string = ''
        self.result_acc = []
        self.localcontext.update({
            'time': time,
            'lines': self.lines,
            'sum_debit': self._sum_debit,
            'sum_credit': self._sum_credit,
            'get_fiscalyear':self._get_fiscalyear,
            'get_filter': self._get_filter,
            'get_start_period': self.get_start_period,
            'get_end_period': self.get_end_period ,
            'get_account': self._get_account,
            'get_journal': self._get_journal,
            'get_start_date':self._get_start_date,
            'get_end_date':self._get_end_date,
            'get_target_move': self._get_target_move,
        })
        self.context = context

    def set_context(self, objects, data, ids, report_type=None):
        new_ids = ids
        obj_move = self.pool.get('account.move.line')
        ctx2 = data['form'].get('used_context',{}).copy()
        self.init_query = obj_move._query_get(self.cr, self.uid, obj='l', context=ctx2)
        if (data['model'] == 'ir.ui.menu'):
            new_ids = 'chart_account_id' in data['form'] and [data['form']['chart_account_id']] or []
            objects = self.pool.get('account.account').browse(self.cr, self.uid, new_ids)
        return super(account_balance, self).set_context(objects, data, new_ids, report_type=report_type)

    #def _add_header(self, node, header=1):
    #    if header == 0:
    #        self.rml_header = ""
    #    return True

    def _get_account(self, data):
        if data['model']=='account.account':
            return self.pool.get('account.account').browse(self.cr, self.uid, data['form']['id']).company_id.name
        return super(account_balance ,self)._get_account(data)

    def lines(self, form, ids=[], done=None):#, level=1):
        def _process_child(accounts, accounts_init, disp_acc, parent):
                account_rec = [acct for acct in accounts if acct['id']==parent][0]
                account_init = {}
                if accounts_init != []:
                    account_init = [acct for acct in accounts_init if acct['id']== account_rec['id']][0]
                else:
                     account_init['balance'] = account_rec['balance']
                     account_init['credit'] = account_rec['credit']
                     account_init['debit'] = account_rec['debit']
                currency_obj = self.pool.get('res.currency')
                acc_id = self.pool.get('account.account').browse(self.cr, self.uid, account_rec['id'])
                currency = acc_id.currency_id and acc_id.currency_id or acc_id.company_id.currency_id
                res = {
                    'id': account_rec['id'],
                    'type': account_rec['type'],
                    'code': account_rec['code'],
                    'name': account_rec['name'],
                    'level': account_rec['level'],
                    'debit': account_rec['debit'],
                    'credit': account_rec['credit'],
                    'balance': account_rec['balance'],
                    'parent_id': account_rec['parent_id'],
                    'bal_type': '',
                    'balance_ac': account_init['balance'],
                    'credit_ac': account_init['credit'],
                    'debit_ac': account_init['debit'],
                }
                self.sum_debit += account_rec['debit']
                self.sum_credit += account_rec['credit']
                if disp_acc == 'bal_movement':
                    if (not currency_obj.is_zero(self.cr, self.uid, currency, res['debit'])) or (not currency_obj.is_zero(self.cr, self.uid, currency, res['credit'])) or not (currency_obj.is_zero(self.cr, self.uid, currency, res['balance'])):
                        self.result_acc.append(res)
                elif disp_acc == 'bal_solde':
                    if not currency_obj.is_zero(self.cr, self.uid, currency, res['balance']):
                        self.result_acc.append(res)
                else:
                    self.result_acc.append(res)
                if account_rec['child_id']:
                    for child in account_rec['child_id']:
                        _process_child(accounts, accounts_init, disp_acc,child)

        obj_account = self.pool.get('account.account')
        fiscalperiod_obj = self.pool.get('account.period')
        if not ids:
            ids = self.ids
        if not ids:
            return []
        if not done:
            done={}

        ctx = self.context.copy()

        ctx['fiscalyear'] = form['fiscalyear_id']
        if form['filter'] == 'filter_period':
            ctx['period_from'] = form['period_from']
            ctx['period_to'] = form['period_to']
        elif form['filter'] == 'filter_date':
            ctx['date_from'] = form['date_from']
            ctx['date_to'] =  form['date_to']
        ctx['state'] = form['target_move']
     #   {'lang': u'en_US', 'tz': False, 'active_model': 'ir.ui.menu', 'department_id': False, 'period_to': 3, 
     #'section_id': False, 'internal_header': True, '_terp_view_name': u'Trial Balance', 'period_from': 2, 'state': 
     #u'posted', 'client': 'web', 'active_ids': [223], 'fiscalyear': 1, 'active_id': 223}
        parents = ids
        context = ctx.copy()
        fy = context['fiscalyear']
        first_period = fiscalperiod_obj.search(self.cr, self.uid, [('fiscalyear_id', '=', fy)], order='date_start', limit=1)[0]
        date_start = fiscalperiod_obj.read(self.cr, self.uid, [first_period], ['date_start'])[0]['date_start']
        child_ids = obj_account._get_children_and_consol(self.cr, self.uid, ids, ctx)
        if child_ids:
            ids = child_ids
        accounts = obj_account.read(self.cr, self.uid, ids, ['type','code','name','debit','credit','balance','parent_id','level','child_id'], ctx)
        #   t: [{'code': u'X0', 'name': u'Chart For Automated Tests', 'level': 0, 'credit': 1907.5, 'parent_id': False, 
        #    'debit': 3415.0, 'child_id': [2, 18], 'balance': 1507.5, 'type': u'view', 'id': 1}, {'code': u'X1', 
        accounts_balance_init = []
        if context.has_key('period_from') and context['period_from'] != first_period or context.has_key('date_from') and context['date_from'] != date_start:
            if context.has_key('period_from'):
                context['period_from'] = first_period
            if context.has_key('date_from'):
                context['date_from'] = date_start
            accounts_balance_init = obj_account.read(self.cr, self.uid, ids, ['type','code','name','debit','credit','balance','parent_id','level','child_id'], context)
        for parent in parents:
                if parent in done:
                    continue
                done[parent] = 1
                _process_child(accounts, accounts_balance_init, form['display_account'],parent)
        return self.result_acc

report_sxw.report_sxw('report.tko.account.account.balance', 'account.account', 'tko_account_pt/report/account_balance.rml', parser=account_balance, header="internal")

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
