# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2012 Thinkopen Solutions, Lda. All Rights Reserved
#    http://www.thinkopensolutions.com.
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import fields, osv
import tools
import decimal_precision as dp
import pooler
from datetime import datetime

class account_guia_tax(osv.osv):
    _name = 'account.tax'
    _description = 'Tax'
    _inherit = 'account.tax'
    
    _columns = {'account_debit_id': fields.many2one('account.account', 'Debit Tax Account')}

account_guia_tax()
    
class account_guia(osv.osv):
    _name = "account.guia"
    _rec_name = "numero"
    _description = "Guia"
    _order = "numero desc, data_carga desc"
    
    def unlink(self, cr, uid, ids, context=None):
        if context is None:
            context = {}
        guias = self.read(cr, uid, ids, ['state'], context=context)
        unlink_ids = []
        for t in guias:
            if t['state'] in ('aberta'):
                unlink_ids.append(t['id'])
            else:
                raise osv.except_osv(('Acção inválida!'), ('Não é possivel eliminar guias arquivadas!'))
        osv.osv.unlink(self, cr, uid, unlink_ids, context=context)
        return True
    
    def action_close(self, cr, uid, ids, context=None):
        for line in self.browse(cr, uid, ids):
            
            #Check if current 'guia' is from later date then last 'guia' fro the same type
            cr.execute("SELECT data_carga FROM account_guia where state = 'arquivada' and tipo = '%s' order by data_carga desc" % line.tipo)
            result = cr.fetchone() 
            if result:
                year = str(result[0][0:4])
                month = str(result[0][5:7])
                day = str(result[0][8:10]) 
                last_date = datetime(int(year), int(month), int(day))
                year = str(line.data_carga[0:4])
                month = str(line.data_carga[5:7])
                day = str(line.data_carga[8:10]) 
                carga_date = datetime(int(year), int(month), int(day))
                if last_date > carga_date:
                    raise osv.except_osv(('Acção inválida!'), ('Existe uma guia do mesmo tipo com data anterior arquivada. Verifique a data da guia.'))
                
            if line.state != 'arquivada':
                if line.linhas_guia:
                    if line.tipo == "remessa":
                        number = self.pool.get('ir.sequence').get(cr, uid, 'account.guia.remessa.sequence'),
                    elif line.tipo == "transporte":
                        number = self.pool.get('ir.sequence').get(cr, uid, 'account.guia.transporte.sequence'),
                    elif line.tipo == "devolucao":
                        number = self.pool.get('ir.sequence').get(cr, uid, 'account.guia.devolucao.sequence'),
                        
                    self.write(cr, uid, line.id, {"numero" : number[0], "state": "arquivada"} or False)
                    return True
                else:
                    raise osv.except_osv(('Guia não tem linhas!'), ('Não é possivel arquivar uma guia sem items. Por favor crie linhas na guia.'))
                    return False
            else:
                return False
            
    def action_cancel(self, cr, uid, ids, context=None):
        for guia in self.browse(cr, uid, ids, context=context):
            if guia:
                self.write(cr, uid, ids, {'state': 'cancelada'})
        return True
    
    def action_get_stock_picking_lines(self, cr, uid, ids, context=None):
        for guia in self.browse(cr, uid, ids, context=context):
            
            if not guia.stock_picking_id.id:
                return False
                
            account_linha_guia_obj = self.pool.get('account.linha.guia')
            stock_move_lines = self.pool.get('stock.move')
            stock_move_lines_ids = stock_move_lines.search(cr, uid, [('picking_id','=',guia.stock_picking_id.id)])
            stock_move_lines_obj = stock_move_lines.browse(cr, uid, stock_move_lines_ids, context=context)
            
            if guia:
                sale_id = guia.stock_picking_id.sale_id.id
                self.write(cr, uid, ids, {'sale_id': sale_id})
                lines_ids = account_linha_guia_obj.search(cr, uid, [('guia_id','=',guia.id)])
                account_linha_guia_obj.unlink(cr, uid, lines_ids)
                for line in stock_move_lines_obj:
                    subtotal = line['price_unit'] * line.product_qty
                    account_linha_guia_obj.create(cr, uid, {'guia_id': guia.id,
                                                            'product_id': line['product_id'].id,
                                                            'price_unit': line['price_unit'],
                                                            'name': line['name'],
                                                            'quantity': line.product_qty,
                                                            'uos_id': line.product_uom.id,
                                                            'price_subtotal': subtotal
                                                            })
        return True
    
    def action_remove_stock_picking_lines(self, cr, uid, ids, context=None):
        for guia in self.browse(cr, uid, ids, context=context):
            if guia:
                pool = self.pool.get('account.linha.guia')
                ids  = pool.search(cr, uid, [('guia_id', '=', guia.id)])
                pool.unlink(cr, uid, ids)
        return True
    
    def _get_currency(self, cr, uid, context=None):
        user = pooler.get_pool(cr.dbname).get('res.users').browse(cr, uid, [uid], context=context)[0]
        if user.company_id:
            return user.company_id.currency_id.id
        return pooler.get_pool(cr.dbname).get('res.currency').search(cr, uid, [('rate','=', 1.0)])[0]
    
    def _get_type(self, cr, uid, context=None):
        if context.has_key('search_default_remessa'):
            return "remessa"
        if context.has_key('search_default_transporte'):
            return "transporte"
        if context.has_key('search_default_devolucao'):
            return "devolucao"
        
    _columns = {
        "numero": fields.char("Numero", size=64, select=1),
        "tipo":fields.selection([("remessa", "Remessa"), ("transporte", "Transporte"), ("devolucao", "Devolução")], "Tipo de Guia", required=True, select=1),
        "state":fields.selection([("aberta", "Aberta"), ("arquivada", "Arquivada"), ("cancelada", "Cancelada")], "Estado", required=True, select=1),
        "data_carga" : fields.date("Data", required=True, select=1),
        "partner_id": fields.many2one("res.partner", "Cliente", required=True),
        "local_carga": fields.char("Local de carga", size=64, required=True, select=1),
        "local_entrega": fields.char("Local de entrega", size=64, required=True, select=1),
        "matricula": fields.char(u"Matrícula", size=8, select=1),
        "linhas_guia": fields.one2many("account.linha.guia", "guia_id", "Linhas Guia"),
        'company_id': fields.many2one('res.company', 'Company', required=True, change_default=True, readonly=True),
        "observacoes": fields.text(u"Observações", size=128, select=1),
        'currency_id': fields.many2one('res.currency', 'Currency', required=True, readonly=True),
        "stock_picking_id": fields.many2one("stock.picking", "Ordem de Entrega"),
        "sale_id": fields.many2one("sale.order", "Ordem de Venda"),
    }
    
    _defaults = {
        "state": lambda * x: 'aberta', 
        'currency_id': _get_currency,
        'company_id': lambda self,cr,uid,c: self.pool.get('res.company')._company_default_get(cr, uid, 'account.guia', context=c),
        'local_carga': "N/ Armazém",
        'local_entrega': "Morada Cliente",
        'tipo': _get_type,
        }
    
    _order = "data_carga desc, numero desc"
    
account_guia()

class account_linha_guia(osv.osv):
    _name = "account.linha.guia"
    _inherit = "account.invoice.line"
    _description = "Linha de Guia"
    
    def unlink(self, cr, uid, ids, context=None):
        cr.commit()
        super(account_linha_guia, self).unlink(cr, uid, ids, context=None)
        return True
       
    _columns = {
        'guia_id': fields.many2one('account.guia', 'Referencia da Guia', ondelete='cascade', select=True),
        'account_id': fields.many2one('account.account', 'Account', domain=[('type','<>','view'), ('type', '<>', 'closed')], help="The income or expense account related to the selected product."),
        'invoice_line_tax_id': fields.many2many('account.tax', 'guia_line_tax','linha_guia_id','tax_id','Impostos'),
        'company_id': fields.related('guia_id','company_id',type='many2one',relation='res.company',string='Company', store=True, readonly=True),
    }
    
account_linha_guia()

class guias_por_dias(osv.osv):
    _name = "guias_por_dias"
    _description = "Guias por dias"
    _auto = False
    _rec_name = "dia"
    
    _columns = {
        "dia": fields.char("Dia", size=128, required=True),
        "total": fields.integer("Total", readonly=True),
     }
    
    def init(self, cr):
        tools.sql.drop_view_if_exists(cr, "guias_por_dias")
        cr.execute("""
            CREATE or REPLACE view guias_por_dias as (
                SELECT
                    min(g.id) as id,
                    to_char(g.data_carga, 'YYYY-MM-DD') as dia,
                    COUNT(g.id) as total
                FROM
                    account_guia g
                GROUP BY
                    to_char(g.data_carga, 'YYYY-MM-DD')
            )
        """)
        
guias_por_dias()
