# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2012 Thinkopen Solutions, Lda. All Rights Reserved
#    http://www.thinkopensolutions.com.
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

{
    'name': 'Portuguese Accounting',
    'version': '1.012',
    'author': 'ThinkOpen Solutions',
    'category': 'Generic Modules/Accounting',
    'description': '''Customization of Accounting for Portugal.
This module implents several Portuguese specific accounting documents:
    Documentos:
        * Notas de Débito;
        * Notas de Crédito;
        * Venda a Dinheiro.
    Guias:
        * Guias de Remessa;
        * Guias de Transporte:
            + Local de entrega;
            + Matrícula da viatura.
        * Guias de Devolução.
It makes vat field required.
NOTE: This documents to be valid, need a certification from Portuguese Treasury, for that you must install and configure the tko_ics_pt module, provided by Thinkopen Solutions.''',
    'website': 'http://www.thinkopensolutions.com/',
    'init_xml': [],
    'depends': ['base',
                 'account',
                 'account_voucher',
                 'base_vat',
                 'purchase',
                 'sale',
                 ],
    'update_xml': ['account_guia_report.xml',
                   'account_invoice_view.xml',
                    'guia_view.xml',
                    'data/account_data2.xml',
                    'account_report.xml',
                    'wizard/account_report_partner_ledger_view.xml',
                    ],
    'demo_xml': [
                 #'demo/account_minimal.xml',
                 ],
    'test': [],
    'installable': True,
    'active': False
}
