# -*- coding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://tiny.be>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import osv, fields

class stock_shop_availability(osv.osv_memory):
    _name = 'stock.shop.availability'
    _description = 'Stock Shop Availability'
    _columns = {
        'shop_id': fields.many2one('sale.shop', 'Shop', required=True),
        'product_id': fields.many2one('product.product', 'Product',required= True),
        'real_stock': fields.float('Real Stock',help="Current quantities of products in selected shop in sale order."),
        'virtual_stock': fields.float('Virtual Stock',help="Current virtual quantities of products selected shop in sale order."),
        'other_shop_real_stock': fields.float('Other Shop Real Stock',help="Current quantities of products in other stock location except selected shop in sale order."),
        'other_shop_virtual_stock': fields.float('Other Shop Virtual Stock',help="Current virtual quantities of products in other stock location except selected shop in sale order."),
    }

    def product_available_other_shop(self, cr, uid, ids, context=None):
        form = self.read(cr, uid, ids, [])[0]
        product_id = form['product_id']
        shop_id = form['shop_id']
        product_obj = self.pool.get('product.product')
        common_id = product_obj.browse(cr, uid, product_id ,context=context).common_product
        fields_name = ['qty_available','virtual_available']
        if common_id:
            stock_common = product_obj._product_available(cr, uid, [product_id] ,fields_name,context=context)

            real_val1 = stock_common[product_id]['qty_available']
            virt_val1 = stock_common[product_id]['virtual_available']
            other_real_val = stock_common[product_id]['qty_available']
            other_virt_val = stock_common[product_id]['virtual_available']
        else:
            stock2 = product_obj._product_available(cr, uid, [product_id] ,fields_name,context=context)
            real_val2 = stock2[product_id]['qty_available']
            virt_val2 = stock2[product_id]['virtual_available']

            context.update({'shop':shop_id,'product_id':product_id})
            stock1 = product_obj._product_available(cr, uid, [product_id] ,fields_name,context=context)
            real_val1 = stock1[product_id]['qty_available']
            virt_val1 = stock1[product_id]['virtual_available']

            other_real_val = real_val2 - real_val1
            other_virt_val = virt_val2 - virt_val1

        self.write(cr, uid, ids, {'real_stock':real_val1,
                                  'virtual_stock':virt_val1,
                                  'other_shop_real_stock':other_real_val,
                                  'other_shop_virtual_stock':other_virt_val,
                                 })
        return True

stock_shop_availability()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
