# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

from osv import fields, osv
from tools import config

class product_product(osv.osv):
    _inherit = "product.product"

    def _product_available(self, cr, uid, ids, field_names=None, arg=False, context=None):
        res = {}
        ctx = context.copy()
        ctx['shop'] = False
        common_ids = self.search(cr,uid,[('common_product','=',True),('id','in',ids)])
        simple_ids = self.search(cr,uid,[('common_product','=',False),('id','in',ids)])
        res = super(product_product,self)._product_available(cr, uid, common_ids, field_names, arg, context=ctx)
        res2 = super(product_product,self)._product_available(cr, uid, simple_ids, field_names, arg, context=context)
        res.update(res2)
        return res

    def _product_available_other_shop(self, cr, uid, ids, name, arg, context=None):
        if context is None:
            context = {}
        res = {}
        common_id = self.search(cr,uid,[('common_product','=',True),('id','in',ids)])
        simple_id = self.search(cr,uid,[('common_product','=',False),('id','in',ids)])
        shop = context.get('shop', False)
        fields_name = ['qty_available','virtual_available']
        real_res = {}
        virtual_res = {}
        if common_id:
            stock_common = self._product_available(cr, uid, common_id ,fields_name, context=context)
            for key,value in stock_common.items():
                real_res[key] = 0.0 
                virtual_res[key] = 0.0

        stock2 = self._product_available(cr, uid, simple_id ,fields_name,context={})
        context.update({'shop':shop})
        stock1 = self._product_available(cr, uid, simple_id ,fields_name,context=context)
        for key,value in stock2.items():
            real_res[key] = stock2[key]['qty_available'] - stock1[key]['qty_available']
            virtual_res[key] = stock2[key]['virtual_available'] - stock1[key]['virtual_available']
        for id in ids:
            res[id] = dict(
                qty_available_other_shop=real_res[id],
                virtual_qty_available_other_shop=virtual_res[id]
            )
        return res

    _columns = {
        'qty_available_other_shop': fields.function(_product_available_other_shop, method=True, type='float', string='Real Other Stock', help="Current quantities of products in other stock location except selected shop in sale order.", multi=True),
        'virtual_qty_available_other_shop': fields.function(_product_available_other_shop, method=True, type='float', string='Virtual Other Stock', help="Current virtual quantities of products in other stock location except selected shop in sale order.", multi=True),
        'common_product' : fields.boolean('Common Product', help="If active it will compute stock for all shops."),
        'qty_available': fields.function(_product_available, method=True, type='float', string='Real Stock', help="Current quantities of products in selected locations or all internal if none have been selected.", multi='qty_available'),
        'virtual_available': fields.function(_product_available, method=True, type='float', string='Virtual Stock', help="Futur stock for this product according to the selected location or all internal if none have been selected. Computed as: Real Stock - Outgoing + Incoming.", multi='qty_available'),
        'incoming_qty': fields.function(_product_available, method=True, type='float', string='Incoming', help="Quantities of products that are planned to arrive in selected locations or all internal if none have been selected.", multi='qty_available'),
        'outgoing_qty': fields.function(_product_available, method=True, type='float', string='Outgoing', help="Quantities of products that are planned to leave in selected locations or all internal if none have been selected.", multi='qty_available'),
    }

product_product()

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
