##############################################################################
#
# Copyright (c) 2008-2009 SIA "KN dati". (http://kndati.lv) All Rights Reserved.
#                    General contacts <info@kndati.lv>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from osv import osv,fields
import netsvc
from report_openoffice import OpenOffice_parser, load_from_file, load_from_source
from report.report_sxw import rml_parse
import base64
import tools


def delete_report_service(name):
    name = 'report.%s' % name
    if netsvc.service_exist( name ):
        del netsvc.SERVICES[name]

def register_report(name, model, tmpl_path, parser):
    name = 'report.%s' % name
    if netsvc.service_exist( name ):
        #service = netsvc.SERVICES[name].parser
        #if isinstance( netsvc.SERVICES[name], OpenOffice_parser ):
	    #    return
        del netsvc.SERVICES[name]
    OpenOffice_parser(name, model, tmpl_path, parser=parser)

class res_company(osv.osv):
    _name = 'res.company'
    _inherit = 'res.company'

    _columns = {
        'report_styles' : fields.binary('Report Styles', help='OpenOffice stylesheet (.odt)'),
    }

res_company()

class report_xml(osv.osv):
    _name = 'ir.actions.report.xml'
    _inherit = 'ir.actions.report.xml'
    
    def __init__(self, pool, cr):
        """Nasty hack for other report compatibility due 
        to the inexistance of selection fields inheritance mechanism"""
        super(report_xml, self).__init__(pool, cr)
        if ('oo-odt', 'OpenOffice - odt/ods output') not in self._columns['report_type'].selection :
            self._columns['report_type'].selection.append(
                                        ('oo-odt', 'OpenOffice - odt/ods output'),
                                )

    def _report_content(self, cursor, user, ids, name, arg, context=None):
        res = {}
        for report in self.browse(cursor, user, ids, context=context):
            data = report[name + '_data'] and base64.decodestring(report[name + '_data'])
            if not data and report[name[:-8]]:
                try:
                    fp = tools.file_open(report[name[:-8]], mode='rb')
                    data = fp.read()
                except:
                    data = False
            res[report.id] = data
        return res

    def _report_content_inv(self, cursor, user, id, name, value, arg, context=None):
        if value:
            self.write(cursor, user, id, {name+'_data': value}, context=context)

    _columns = {
        'styles_mode': fields.selection([
            ('default','Not used'),
            ('global', 'Global'),
            ('specified', 'Specified'),
            ], string='Stylesheet', required=True),
        'report_styles' : fields.binary('Template Styles', help='OpenOffice stylesheet (.odt)'),
        'parser_def': fields.text('Parser Definition'),
        'parser_loc':fields.char('Parser location', size=128),
        'parser_state':fields.selection([
            ('default','Default'),
            ('def','Definition'),
            ('loc','Location'),
        ],'State of Parser', select=True),
        'report_sxw_content': fields.function(_report_content,
            fnct_inv=_report_content_inv, method=True,
            type='binary', string='SXW content',),
    }

    def unlink(self, cr, uid, ids, context=None):
        #TODO: process before delete resource
        trans_obj = self.pool.get('ir.translation')
        trans_ids = trans_obj.search(cr, uid, [('type','=','report'),('res_id','in',ids)])
        trans_obj.unlink(cr, uid, trans_ids)
        res = super(report_xml, self).unlink(cr, uid, ids, context)
        return res

    def create(self, cr, user, vals, context={}):
        if context and not self.pool.get('ir.model').search(cr, user, [('model','=',vals['model'])]):
            raise osv.except_osv(_('Object model is not correct !'),_('Please check "Object" field !') )
        if 'report_type' in vals and vals['report_type'] in ('oo-odt', 'oo-pdf'):
            parser=rml_parse
            if vals['parser_state']=='loc' and vals['parser_loc']:
                parser=load_from_file(vals['parser_loc'], cr.dbname, vals['name'].lower().replace(' ','_')) or parser
            elif vals['parser_state']=='def' and vals['parser_def']:
                parser=load_from_source("from report import report_sxw\n"+vals['parser_def']) or parser
            try:
                register_report( vals['report_name'], vals['model'], vals.get('report_rml', False), parser)
            except Exception, e:
                raise osv.except_osv(_('Report registration error !'), _('Report was not registered in system !'))
        res_id = super(report_xml, self).create(cr, user, vals, context)
        return res_id

    def write(self, cr, user, ids, vals, context=None):
        if type(ids)==list:
            ids = ids[0]
        record = self.read(cr, user, ids)
        if context and 'model' in vals and not self.pool.get('ir.model').search(cr, user, [('model','=',vals['model'])]):
            raise osv.except_osv(_('Object model is not correct !'),_('Please check "Object" field !') )
        if vals.get('report_type', record['report_type']) in ('oo-odt', 'oo-pdf'):
            parser=rml_parse
            if vals.get('parser_state', False)=='loc':
                parser = load_from_file(vals.get('parser_loc', False) or record['parser_loc'], cr.dbname, record['id']) or parser
            elif vals.get('parser_state', False)=='def':
                parser = load_from_source("from report import report_sxw\n"+(vals.get('parser_loc', False) or record['parser_def'] or '')) or parser
            elif vals.get('parser_state', False)=='default':
                parser = rml_parse
            elif record['parser_state']=='loc':
                parser = load_from_file(record['parser_loc'], cr.dbname, record['id']) or parser
            elif record['parser_state']=='def':
                parser = load_from_source("from report import report_sxw\n"+record['parser_def']) or parser
            elif record['parser_state']=='default':
                parser = rml_parse

            if vals.get('parser_loc', False):
                parser=load_from_file(vals['parser_loc'], cr.dbname, record['id']) or parser
            elif vals.get('parser_def', False):
                parser=load_from_source("from report import report_sxw\n"+vals['parser_def']) or parser
            if vals.get('report_name', False) and vals['report_name']!=record['report_name']:
                delete_report_service(record['report_name'])
                report_name = vals['report_name']
            else:
                report_name = record['report_name']
            try:
                register_report( report_name, vals.get('model', record['model']), vals.get('report_rml', record['report_rml']), parser)
            except Exception, e:
                raise osv.except_osv(_('Report registration error !'), _('Report was not registered in system !'))

        res = super(report_xml, self).write(cr, user, ids, vals, context)
        return res

    _defaults = {
        #'report_type' : lambda*a: 'oo-odt',
        'styles_mode' : lambda*a: 'default',
        'parser_state': lambda*a: 'default',
        'parser_def':lambda*a: """class Parser(report_sxw.rml_parse):
    def __init__(self, cr, uid, name, context):
        super(Parser, self).__init__(cr, uid, name, context)
        self.localcontext.update({})"""
    }
report_xml()

class ir_translation(osv.osv):
    _name = 'ir.translation'
    _inherit = 'ir.translation'
    _columns = {
        'type': fields.selection([
				('field', 'Field'),
				('model', 'Object'),
				('rml', 'RML'),
				('report', 'Report'),
				('selection', 'Selection'),
				('view', 'View'),
				('wizard_button', 'Wizard Button'),
				('wizard_field', 'Wizard Field'),
				('wizard_view', 'Wizard View'),
				('xsl', 'XSL'),
				('help', 'Help'),
				('code', 'Code'),
				('constraint', 'Constraint'),
            ], string='Type', size=16, select=True),
    }

ir_translation()

