# -*- encoding: utf-8 -*-

#########################################################################
#                                                                       #
# Copyright (C) 2009  Domsense s.r.l.                                   #
# @authors: Simone Orsi, KN dati Ltd (www.kndati.lv)                    #
#                                                                       #
#This program is free software: you can redistribute it and/or modify   #
#it under the terms of the GNU General Public License as published by   #
#the Free Software Foundation, either version 3 of the License, or      #
#(at your option) any later version.                                    #
#                                                                       #
#This program is distributed in the hope that it will be useful,        #
#but WITHOUT ANY WARRANTY; without even the implied warranty of         #
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          #
#GNU General Public License for more details.                           #
#                                                                       #
#You should have received a copy of the GNU General Public License      #
#along with this program.  If not, see <http://www.gnu.org/licenses/>.  #
#########################################################################

import os
import tempfile
import report
from report.report_sxw import *
import zipfile
import StringIO
from xml.dom import minidom
import base64
from osv import osv
from tools.translate import _
import time

from relatorio.templates.opendocument import Template
#from genshi.filters import Translator
import pooler

import netsvc
logger = netsvc.Logger()

try:
    from report_openoffice_pdf.DocumentConverter import DocumentConverter
except Exception, e:
    DocumentConverter = False

from ExtraFunctions import ExtraFunctions

from tools import debug

class OpenOffice_parser(report_sxw):

    def __init__(self, name, table, rml=False, parser=False, header=True, store=False):
        report_sxw.__init__(self, name, table, rml, parser, header, store)

    def _doc_optimized(self, cr, uid, data, document):
        pool = pooler.get_pool(cr.dbname)
        out_oo = StringIO.StringIO()
        in_oo = StringIO.StringIO(document)
        inzip = zipfile.ZipFile(in_oo, mode='r')
        content_data = inzip.read('content.xml')
        styles_data = inzip.read('styles.xml')
        meta_data = inzip.read('meta.xml')
        manifest_data = inzip.read('META-INF/manifest.xml')
        ##### manifest.xml editing #####
        manifestdoc = minidom.parseString(manifest_data)
        manifest = [x.getAttribute("manifest:full-path") for x in manifestdoc.getElementsByTagName('manifest:file-entry') \
                            if x.getAttribute("manifest:media-type")!="\\"]
        namelist = filter(lambda a: a not in ('META-INF/manifest.xml','mimetype'), inzip.namelist())
        thumbnails_nodes = filter(lambda a: a.getAttribute("manifest:full-path").startswith("Thumbnails"), \
                                    manifestdoc.getElementsByTagName('manifest:file-entry'))
        for thmb in thumbnails_nodes:
            manifestdoc.firstChild.removeChild(thmb)
        ################################
        for name in namelist:
            if name not in manifest:
                dirname = os.path.dirname(name)
                if dirname not in manifest:
                    newNode = manifestdoc.createElement("manifest:file-entry")
                    newNode.setAttribute("manifest:media-type", "")
                    newNode.setAttribute("manifest:full-path", dirname+"/")
                    manifestdoc.firstChild.appendChild(newNode)
                    manifest.append(dirname)                
                newNode = manifestdoc.createElement("manifest:file-entry")
                newNode.setAttribute("manifest:media-type", "")
                newNode.setAttribute("manifest:full-path", name)
                manifestdoc.firstChild.appendChild(newNode)
        ################################

        ####### meta.xml editing #######
        metadoc = minidom.parseString(meta_data)
        user_name = pool.get('res.users').browse(cr, uid, uid, {}).name
        model_id = pool.get('ir.model').search(cr, uid, [('model','=',data['model'])])[0]
        model_name = pool.get('ir.model').browse(cr, uid, model_id).name
        if metadoc.getElementsByTagName('meta:creation-date'):
            cdate_node = metadoc.getElementsByTagName('meta:creation-date')[0].childNodes[0]
            cdate_node.nodeValue=time.strftime('%Y-%m-%dT%H:%M:%S')
        else:
            newNode=metadoc.createElement("meta:creation-date")
            newText=metadoc.createTextNode(time.strftime('%Y-%m-%dT%H:%M:%S'))
            newNode.appendChild(newText)
        if metadoc.getElementsByTagName('dc:date'):
            date_node = metadoc.getElementsByTagName('dc:date')[0].childNodes[0]
            date_node.nodeValue=time.strftime('%Y-%m-%dT%H:%M:%S')
        else:
            newNode=metadoc.createElement("dc:date")
            newText=metadoc.createTextNode(time.strftime('%Y-%m-%dT%H:%M:%S'))
            newNode.appendChild(newText)
        if metadoc.getElementsByTagName('meta:editing-cycles'):
            date_node = metadoc.getElementsByTagName('meta:editing-cycles')[0].childNodes[0]
            date_node.nodeValue=1
        else:
            newNode=metadoc.createElement("meta:editing-cycles")
            newText=metadoc.createTextNode(1)
            newNode.appendChild(newText)
        if metadoc.getElementsByTagName('dc:creator'):
            date_node = metadoc.getElementsByTagName('dc:creator')[0].childNodes[0]
            date_node.nodeValue=user_name
        else:
            newNode=metadoc.createElement("dc:creator")
            newText=metadoc.createTextNode(user_name)
            newNode.appendChild(newText)
        if metadoc.getElementsByTagName('dc:title'):
            date_node = metadoc.getElementsByTagName('dc:title')[0].childNodes[0]
            date_node.nodeValue=model_name
        else:
            newNode=metadoc.createElement("dc:title")
            newText=metadoc.createTextNode(model_name)
            newNode.appendChild(newText)
        ################################
        outzip = zipfile.ZipFile(out_oo, mode='w')
        outzip.compression = 8
        for file_inf in inzip.infolist():
            if file_inf.filename=='META-INF/manifest.xml':
                outzip.writestr(file_inf.filename, manifestdoc.toxml('utf-8'))
            elif file_inf.filename=='meta.xml':
                outzip.writestr(file_inf.filename, metadoc.toxml('utf-8'))
            elif file_inf.filename=='content.xml' and not content_data.startswith('<?xml'):
                outzip.writestr(file_inf.filename, '<?xml version="1.0" encoding="UTF-8"?>\n'+content_data)
            elif file_inf.filename=='styles.xml' and not styles_data.startswith('<?xml'):
                outzip.writestr(file_inf.filename, '<?xml version="1.0" encoding="UTF-8"?>\n'+styles_data)
            elif file_inf.filename=='Thumbnails/thumbnail.png':
                continue
            else:
                outzip.writestr(file_inf.filename, inzip.read(file_inf.filename))
        inzip.close()
        in_oo.close()
        outzip.close()
        return out_oo.getvalue()

    def create_relatorio_report(self, cr, uid, ids, data, report_xml, context=None, output='odt'):
        """ Returns an odt or a pdf generated with relatorio
        """
        #####################################################################################################
        def replaceStyles(node_list1, node_list2, name):
            o_index = 0
            while(o_index<len(node_list1)):
                n_index=0
                while(n_index<len(node_list2)):
                    if node_list1[o_index].getAttribute(name)==node_list2[n_index].getAttribute(name):
                        node_list1[o_index].parentNode.replaceChild(node_list2[n_index], node_list1[o_index])
                    n_index+=1
                o_index+=1
            return node_list1
        ######################################################################################################

        if not context:
            context={}
        context = context.copy()
        
        objects = self.getObjects(cr, uid, ids, context)
        oo_parser = self.parser(cr, uid, self.name2, context=context)
        oo_parser.objects = objects

        ############# Get XML ############
        xml_data_fields = oo_parser.localcontext.get('xml_data_fields', False)
        if xml_data_fields:
            for field in xml_data_fields:
                for o in objects:
                    if getattr(o, field):
                        xml_data = base64.decodestring(getattr(o, field))
                        xmldoc = minidom.parseString(xml_data)
                        setattr(o, field, xmldoc.firstChild)
        ############## Get other Tamplate ##############
        file_data = report_xml.report_sxw_content
        if hasattr(oo_parser, 'get_template'):
            pool = pooler.get_pool(cr.dbname)
            record = pool.get(data['model']).browse(cr, uid, data['id'], {})
            new_template = oo_parser.get_template(cr, uid, record)
            file_data = new_template or file_data
        ################################################
        if not file_data:
            return False, output
        in_oo = StringIO.StringIO(file_data)
        inzip = zipfile.ZipFile(in_oo, mode='r')
        outzip = False
        ############### Styles usage #################
        if report_xml.styles_mode!='default':
            out_oo = StringIO.StringIO()
            outzip = zipfile.ZipFile(out_oo, mode='a')
            if report_xml.styles_mode=='global':
                pool = pooler.get_pool(cr.dbname)
                company_id = pool.get('res.users')._get_company(cr, uid, context=context)
                style_content = pool.get('res.company').browse(cr, uid, company_id, context=context).report_styles
            elif report_xml.styles_mode=='specified':
                style_content = report_xml.report_styles
            if style_content:
                style_info = None
                style_xml = None
                for f in inzip.infolist():
                    if f.filename == 'styles.xml':
                        style_info = f
                        style_xml = inzip.read(f.filename)
                        continue
                    outzip.writestr(f.filename, inzip.read(f.filename))

                pictures = []
                dom_style = minidom.parseString(style_xml)
                node_style = dom_style.documentElement

                style2_io = StringIO.StringIO()
                style2_io.write(base64.decodestring(style_content))
                style2_z = zipfile.ZipFile(style2_io, mode='r')
                style2_xml = style2_z.read('styles.xml')
                for file_name in style2_z.namelist():
                    if file_name.startswith('Pictures'):
                        picture = style2_z.read(file_name)
                        pictures.append((file_name, picture))
                style2_z.close()
                style2_io.close()
                dom_style2 = minidom.parseString(style2_xml)
                node_style2 = dom_style2.documentElement
                font_face_new = node_style2.getElementsByTagName('office:font-face-decls')
                font_face_orig = node_style.getElementsByTagName('office:font-face-decls')
                orig_styles = replaceStyles(font_face_orig, font_face_new, 'style:name')
                orig_styles = node_style.getElementsByTagName('style:style')
                new_styles = node_style2.getElementsByTagName('style:style')
                orig_styles = replaceStyles(orig_styles, new_styles, 'style:name')

                outzip.writestr(style_info,
                        '<?xml version="1.0" encoding="UTF-8"?>' + \
                                dom_style.documentElement.toxml('utf-8'))

                for ffile, picture in pictures:
                    outzip.writestr(ffile, picture)
        ##############################################
        if not outzip or not outzip.namelist():
            out_oo = StringIO.StringIO(file_data)
            outzip = zipfile.ZipFile(out_oo, mode='a')
        ############### Replace tags 'text:text-input' on 'text:placeholder' #################
        output_data = {}
        for file_name in ('content.xml','styles.xml'):
            content = outzip.read(file_name)
            xmldoc = minidom.parseString(content)
            for oldNode in xmldoc.getElementsByTagName('text:text-input'):
                input_val = oldNode.getAttribute("text:description")
                if input_val.startswith('<') and input_val.endswith('>'):
                    if input_val=='<_()>':
                        input_val = "<_('%s')>" % oldNode.firstChild.nodeValue
                    newNode = xmldoc.createElement("text:placeholder")
                    newNode.setAttribute("text:placeholder-type", "text")
                    textNode=xmldoc.createTextNode(input_val)
                    newNode.appendChild(textNode)
                    oldNode.parentNode.replaceChild(newNode,oldNode)

            output_data[file_name] = xmldoc.toxml('utf-8')

        outzip = zipfile.ZipFile(out_oo, mode='w')
        for f_info in inzip.infolist():
            if f_info.filename in output_data.keys():
                outzip.writestr(f_info.filename, output_data[f_info.filename])
            else:
                outzip.writestr(f_info.filename, inzip.read(f_info.filename))
        ######################################################################################
        inzip.close()
        in_oo.close()
        outzip.close()
        file_data = out_oo.getvalue()
        ##############################################

        oo_parser.localcontext['objects'] = objects
        oo_parser.localcontext['data'] = data
        if len(objects)==1:
            oo_parser.localcontext['o'] = objects[0]
        xfunc = ExtraFunctions(cr, uid, report_xml.id, oo_parser.localcontext)
        oo_parser.localcontext.update(xfunc.functions)

        toremove = [] # for temp objects to be removed
        toclose = [] # for StringIO objects to be closed
        odt_fd, odt_path = tempfile.mkstemp(suffix='.odt', prefix='openoffice-report-')
        toremove.append( (odt_fd,odt_path) )
        fd = file(odt_path, 'wb')
        fd.write( file_data )
        fd.close()
        
        basic = Template(source=None, filepath=odt_path)

        data = self._doc_optimized(cr, uid, data, basic.generate(**oo_parser.localcontext).render().getvalue())

        if output!='odt' and DocumentConverter:
            convert = False
            pool = pooler.get_pool(cr.dbname)
            module_id = pool.get('ir.module.module').search(cr, uid, [('name','=','report_openoffice_pdf')])
            if module_id:
                if pool.get('ir.module.module').browse(cr, uid, module_id[0], context=context).state=='installed':
                    convert = True
            else:
                convert = True
            if convert:
                try:
                    cr.execute("SELECT host, port FROM oo_config")
                    host, port = cr.fetchone()
                    DC = DocumentConverter(host, port)
                    data = DC.convertByStream(data)
                    del DC
                except Exception, e:
                    print e
                    output='odt'
            else:
                output='odt'

        for item in toclose:
            item.close()

        for item in toremove:
            os.close(item[0])
            os.remove(item[1])

        return data, output

    # override needed to keep the attachments' storing procedure
    def create_single_pdf(self, cr, uid, ids, data, report_xml, context=None):
        if not context:
            context={}
        if report_xml.report_type =='oo-pdf':
            return self.create_relatorio_report(cr, uid, ids, data, report_xml, context=context, output='pdf')
        elif report_xml.report_type =='oo-odt':
            return self.create_relatorio_report(cr, uid, ids, data, report_xml, context=context, output='odt')
        logo = None
        context = context.copy()
        title = report_xml.name
        rml = report_xml.report_rml_content
        oo_parser = self.parser(cr, uid, self.name2, context=context)
        objs = self.getObjects(cr, uid, ids, context)
        oo_parser.set_context(objs, data, ids, report_xml.report_type)
        processed_rml = self.preprocess_rml(etree.XML(rml),report_xml.report_type)
        if report_xml.header:
            oo_parser._add_header(processed_rml)
        if oo_parser.logo:
            logo = base64.decodestring(oo_parser.logo)
        create_doc = self.generators[report_xml.report_type]
        pdf = create_doc(etree.tostring(processed_rml),oo_parser.localcontext,logo,title.encode('utf8'))
        return (pdf, report_xml.report_type)

    def create_source_odt(self, cr, uid, ids, data, report_xml, context=None):
        if not context:
            context={}
        pool = pooler.get_pool(cr.dbname)
        attach = report_xml.attachment
        if attach:
            objs = self.getObjects(cr, uid, ids, context)
            results = []
            for obj in objs:
                aname = eval(attach, {'object':obj, 'time':time})
                result = False
                if report_xml.attachment_use and aname and context.get('attachment_use', True):
                    aids = pool.get('ir.attachment').search(cr, uid, [('datas_fname','=',aname+'.odt'),('res_model','=',self.table),('res_id','=',obj.id)])
                    if aids:
                        brow_rec = pool.get('ir.attachment').browse(cr, uid, aids[0])
                        if not brow_rec.datas:
                            continue
                        d = base64.decodestring(brow_rec.datas)
                        results.append((d,'odt'))
                        continue
                result = self.create_single_pdf(cr, uid, [obj.id], data, report_xml, context)
                try:
                    if aname:
                        name = aname+'.'+result[1]
                        pool.get('ir.attachment').create(cr, uid, {
                            'name': aname,
                            'datas': base64.encodestring(result[0]),
                            'datas_fname': name,
                            'res_model': self.table,
                            'res_id': obj.id,
                            }, context=context
                        )
                        cr.commit()
                except Exception,e:
                     import traceback, sys
                     tb_s = reduce(lambda x, y: x+y, traceback.format_exception(sys.exc_type, sys.exc_value, sys.exc_traceback))
                     netsvc.Logger().notifyChannel('report', netsvc.LOG_ERROR,str(e))
                results.append(result)

        return self.create_single_pdf(cr, uid, ids, data, report_xml, context)

    # override needed to intercept the call to the proper 'create' method
    def create(self, cr, uid, ids, data, context=None):
        pool = pooler.get_pool(cr.dbname)
        ir_obj = pool.get('ir.actions.report.xml')
        report_xml_ids = ir_obj.search(cr, uid,
                [('report_name', '=', self.name[7:])], context=context)
        if report_xml_ids:
            report_xml = ir_obj.browse(cr, uid, report_xml_ids[0], context=context)
            report_xml.report_rml = None
            report_xml.report_rml_content = None
            report_xml.report_sxw_content_data = None
            report_rml.report_sxw_content = None
            report_rml.report_sxw = None
        else:
            title = ''
            rml = tools.file_open(self.tmpl, subdir=None).read()
            report_type= data.get('report_type', 'pdf')
            class a(object):
                def __init__(self, *args, **argv):
                    for key,arg in argv.items():
                        setattr(self, key, arg)
            report_xml = a(title=title, report_type=report_type, report_rml_content=rml, name=title, attachment=False, header=self.header)

        report_type = report_xml.report_type
        if report_type in ['sxw','odt']:
            fnct = self.create_source_odt
        elif report_type in ['oo-pdf']:
            fnct = self.create_source_pdf
        elif report_type=='html2html':
            fnct = self.create_source_html2html
        elif report_type in ['oo-odt']:
            #fnct = self.create_relatorio_report
            fnct = self.create_source_odt
        else:
            return super(OpenOffice_parser, self).create(cursor, uid, ids, data, context)
        return fnct(cr, uid, ids, data, report_xml, context)

class ReportTypeException(Exception):
    def __init__(self, value):
      self.parameter = value
    def __str__(self):
      return repr(self.parameter)

#########################################################################

import imp, sys
from tools.config import config

def load_from_file(path, dbname, key):
    class_inst = None
    expected_class = 'Parser'

    try:
        if path.find(config['addons_path'])==-1:
            filepath=config['addons_path']+os.path.sep+path
        filepath = os.path.normpath(filepath)
        if not os.path.lexists(filepath):
            filepath = os.path.normpath(config['root_path']+os.path.sep+path)
        sys.path.append(os.path.dirname(filepath))
        mod_name,file_ext = os.path.splitext(os.path.split(filepath)[-1])
        mod_name = '%s_%s_%s' % (dbname,mod_name,key)

        if file_ext.lower() == '.py':
            py_mod = imp.load_source(mod_name, filepath)

        elif file_ext.lower() == '.pyc':
            py_mod = imp.load_compiled(mod_name, filepath)

        if expected_class in dir(py_mod):
            class_inst = py_mod.Parser
        return class_inst
    except Exception, e:
        return None

def load_from_source(source):
    expected_class = 'Parser'
    context = {'Parser':None}
    try:
        exec source in context
        return context['Parser']
    except Exception, e:
        return None

def register_report(name, model, tmpl_path, parser):
    name = 'report.%s' % name
    if netsvc.service_exist( name ):
        #service = netsvc.SERVICES[name].parser
        if isinstance( netsvc.SERVICES[name], OpenOffice_parser ):
	        return
        del netsvc.SERVICES[name]
    OpenOffice_parser(name, model, tmpl_path, parser=parser)

old_register_all = report.interface.register_all
def new_register_all(db):
    value = old_register_all(db)

    cr = db.cursor()

    cr.execute("SELECT * FROM ir_act_report_xml")
    records = cr.dictfetchall()
    cr.close()
    for record in records:
        if record['report_type'] in ('oo-odt', 'oo-pdf'):
            parser=rml_parse
            if record['parser_state']=='loc' and record['parser_loc']:
                parser=load_from_file(record['parser_loc'], db.dbname, record['id']) or parser
            elif record['parser_state']=='def' and record['parser_def']:
                parser=load_from_source("from report import report_sxw\n"+record['parser_def']) or parser
            register_report( record['report_name'], record['model'], record['report_rml'], parser)
    return value

report.interface.register_all = new_register_all

