#!/usr/bin/python
# -*- coding: utf8 -*-

###########################################################
# Developed by Kaspars Vilkens - KN dati Ltd. (c) 2009
# Supported currencies: LVL, EUR, USD
# Supported sum: 0 ... 999999999999.99
# Supported languages: lv_LV, en_US, ru_RU
###########################################################

def currency_to_text(sum, currency, language):
    if sum < 0 or sum > 999999999999.99 : raise 'Sum out of bounds: must be from 0 to 999999999999.99'
    if currency not in ['LVL', 'EUR', 'USD'] : raise 'Unsupported or no currency: must be one of (LVL, EUR, USD)'
    if language not in ['lv_LV', 'en_US', 'ru_RU'] : raise 'Unsupported or no language: must be one of (lv_LV, en_US, ru_RU)'
#--------------for currencies with 100 fractions
    if currency == 'LVL' \
    or currency == 'EUR' \
    or currency == 'USD' :
	sum = float(sum)
        sum = round(sum, 2)
	# find out digits before floating point - currency
        sum_cur = int(sum)
        # find out digits after floating point - fractions
        sum_frc = int(round((sum - sum_cur) * 100,0))
        cur_in_words = dtowords(sum_cur, language)
        #print cur_in_words
	frc_in_words = dtowords(sum_frc, language)
	#print frc_in_words
	#------------------------------------
	if language == 'lv_LV' :
    	    if sum_cur == 1 or (str(sum_cur)[-1] == '1' and str(sum_cur)[-2] != '1') : # is the currency sum one
    		if currency == 'LVL' :
		    cur_in_words += ' lats'
		elif currency == 'EUR' :
		    cur_in_words += ' eiro'
		elif currency == 'USD' :
		    cur_in_words += ' dolārs'
    	    else :
    		if currency == 'LVL' :
		    cur_in_words += ' lati'
		elif currency == 'EUR' :
		    cur_in_words += ' eiro'
		elif currency == 'USD' :
		    cur_in_words += ' dolāri'
            
	    if sum_frc == 1 or (str(sum_frc)[-1] == '1' and str(sum_frc)[-2] != '1') : # is the fraction sum one
		if currency == 'LVL' :
        	    frc_in_words += ' santīms'
        	elif currency == 'EUR' or currency == 'USD' :
        	    frc_in_words += ' cents'
    	    else :
    		if currency == 'LVL' :
		    frc_in_words += ' santīmi'
		elif currency == 'EUR' or currency == 'USD' :
		    frc_in_words += ' centi'
	#------------------------------------
	if language == 'en_US' :
	    if sum_cur == 1 or (str(sum_cur)[-1] == '1' and str(sum_cur)[-2] != '1') : # is the currency sum one
    		if currency == 'LVL' :
		    cur_in_words += ' Latvian lats'
		elif currency == 'EUR' :
		    cur_in_words += ' euro'
		elif currency == 'USD' :
		    cur_in_words += ' US dollar'
    	    else :
    		if currency == 'LVL' :
		    cur_in_words += ' Latvian lats'
		elif currency == 'EUR' :
		    cur_in_words += ' eiros'
		elif currency == 'USD' :
		    cur_in_words += ' dolars'
    	    if sum_frc == 1 or (str(sum_frc)[-1] == '1' and str(sum_frc)[-2] != '1') : # is the fraction sum one
		if currency == 'LVL' :
        	    frc_in_words += ' santim'
        	elif currency == 'EUR' or currency == 'USD' :
        	    frc_in_words += ' cent'
    	    else :
    		if currency == 'LVL' :
		    frc_in_words += ' santims'
		elif currency == 'EUR' or currency == 'USD' :
		    frc_in_words += ' cents'
	#------------------------------------
	if language == 'ru_RU' :
	    if sum_cur == 1 or (str(sum_cur)[-1] == '1' and str(sum_cur)[-2] != '1') : # is the currency sum one
    		if currency == 'LVL' :
		    cur_in_words += ' лат'
		elif currency == 'EUR' :
		    cur_in_words += ' евро'
		elif currency == 'USD' :
		    cur_in_words += ' доллар США'
    	    elif (sum_cur in [2, 3, 4]) or (str(sum_cur)[-1] in ['2', '3', '4'] and str(sum_cur)[-2] != '1') :
    		if currency == 'LVL' :
		    cur_in_words += ' лата'
		elif currency == 'EUR' :
		    cur_in_words += ' евро'
		elif currency == 'USD' :
		    cur_in_words += ' доллара США'
	    elif (sum_cur >= 5 and sum_cur <= 20) or str(sum_cur)[-1] not in [2, 3, 4] :
    		if currency == 'LVL' :
		    cur_in_words += ' латов'
		elif currency == 'EUR' :
		    cur_in_words += ' евро'
		elif currency == 'USD' :
		    cur_in_words += ' долларов США'
		    		    
	    if sum_frc == 1 or (str(sum_frc)[-1] == '1' and str(sum_frc)[-2] != '1') : # is the fraction one
    		if currency == 'LVL' :
		    frc_in_words += ' сантим'
		elif currency == 'EUR' or currency == 'USD' :
		    frc_in_words += ' цент'
    	    elif (sum_frc in [2, 3, 4]) or (str(sum_frc)[-1] in ['2', '3', '4'] and str(sum_frc)[-2] != '1') :
    		if currency == 'LVL' :
		    frc_in_words += ' сантима'
		elif currency == 'EUR' or currency == 'USD' :
		    frc_in_words += ' цента'
	    elif (sum_frc >= 5 and sum_frc <= 20) or str(sum_frc)[-1] not in [2, 3, 4] :
    		if currency == 'LVL' :
		    frc_in_words += ' сантимов'
		elif currency == 'EUR' or currency == 'USD' :
		    frc_in_words += ' центов'

    return (cur_in_words + ' ' + frc_in_words).strip()
    
    
def dtowords(sum_integers, language):
    diginwords = ''
    if sum_integers == 0 :
	return wordify('0', 0, language)
    elif sum_integers > 0 :
        lengthx = len(str(sum_integers))
        nrchunks = (lengthx / 3)
	if nrchunks < (float(lengthx) / 3) :
    	    nrchunks+=1
	inc = 1
	while inc <= nrchunks :
    	    startpos = (lengthx - inc * 3)
    	    chunklength = 3
    	    if startpos < 0 :
        	chunklength += startpos
        	startpos = 0
    	    chunk = str(sum_integers)[startpos : startpos + chunklength]
    	    #print str(startpos)+' '+str(chunklength)+' '+ chunk
    	    wordified = wordify(chunk, inc-1, language)
    	    inc += 1
    	    spacer = ''
    	    if len(diginwords) > 0 :
    	        spacer = ' '
    	    diginwords = wordified + spacer + diginwords
	return diginwords

def wordify(chunk, chunknr, language):
    #print 'chunk '+str(chunk)
    #print 'cunknr '+str(chunknr)
    words = ''
    if language == 'lv_LV' :
	skaitli = ['nulle', 'viens', 'divi', 'trīs', 'četri', 'pieci', 'seši', 'septiņi', 'astoņi', 'deviņi']
	skaitlix = ['nulle', 'vien', 'div', 'trīs', 'četr', 'piec', 'seš', 'septiņ', 'astoņ', 'deviņ']
	skaitli_teens = ['desmit', 'vienpadsmit', 'divpadsmit', 'trīspadsmit', 'četrpadsmit', 'piecpadsmit', 'sešpadsmit', 'septiņpadsmit', 'astoņpadsmit', 'deviņpadsmit']
	daudzums = ['simts', ' tūkstotis', ' miljons', ' miljards']
	daudzumsx = [' simti', ' tūkstoši', ' miljoni', ' miljardi']
    elif language == 'en_US' :
	skaitli = ['zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine']
	skaitlix = ['zero', 'one', 'twen', 'thir', 'four', 'fif', 'six', 'seven', 'eigh', 'nine']
	skaitli_teens = ['ten', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen']
	daudzums = [' hundred', ' thousand', ' million', ' billion']
	daudzumsx = daudzums
    elif language == 'ru_RU' :
	skaitli = ['ноль', 'один', 'два', 'три', 'четыре', 'пять', 'шесть', 'семь', 'восемь', 'девять']
	skaitlix = ['', 'один', 'двa', 'три', 'четыре', 'пять', 'шесть', 'семь', 'восемь', 'девять']
	skaitli_teens = ['десять', 'одиннадцать', 'двенадцать', 'тринадцать', 'четырнадцать', 'пятнадцать', 'шестнадцать', 'семнадцать', 'восемнадцать', 'девятнадцать']
	daudzums = ['стo', ' тысяча', ' миллион', ' миллиард']
	daudzumsx = ['сoт', ' тысяч', ' миллионов', ' миллиардов']
    digit1 = ''
    digit2 = ''
    digit3 = ''
    chunklength = len(chunk)
    # placing digits in right places
    if chunklength == 1 :
        digit3 = chunk[0 : 1]
    if chunklength == 2 :
	digit2 = chunk[0 : 1]
	digit3 = chunk[1 : 2]
    if chunklength == 3 :
	digit1 = chunk[0 : 1]
	digit2 = chunk[1 : 2]
	digit3 = chunk[-1]
    #print chunklength
    #print 'digit1 '+ digit1
    #print 'digit2 '+ digit2
    #print 'digit3 '+ digit3
    # processing zero
    if chunklength == 1 and digit3  == '0' :
	return skaitli[0]
    # processing hundreds
    if chunklength == 3 :
        if digit1 == '1' :
            if language == 'lv_LV' or language == 'ru_RU' :
        	words += daudzums[0]
            elif language == 'en_US' :
        	words += skaitli[int(digit1)] + daudzumsx[0]
        else :
            if language == 'lv_LV' :
        	if int(digit1) > 1 : words += skaitli[int(digit1)] + daudzumsx[0]
            elif language == 'en_US' :
        	if int(digit1) > 1 : words += skaitli[int(digit1)] + daudzumsx[0]
            elif language == 'ru_RU' :
        	if int(digit1) == 2 :
        	    words += 'двести'
        	elif int(digit1) == 3 :
        	    words += 'триста'
        	elif int(digit1) == 4 :
        	    words += 'четыреста'
        	elif int(digit1) >= 5 :
        	    words += skaitli[int(digit1)] + daudzumsx[0]
    # processing tens
    if chunklength > 1:
        spacer = ''
        if len(words) > 0 : spacer = ' '
        if digit2 == '1' :
    	    if language == 'lv_LV' or language == 'en_US' or language == 'ru_RU' :
        	words += spacer + skaitli_teens[int(digit3)]
        else :
    	    if language == 'lv_LV' :
    		if int(digit2) > 1 and int(digit2) > 0:
            	    words += spacer + skaitlix[int(digit2)] + 'desmit'
            elif language == 'en_US' :
        	if int(digit2) > 1 and int(digit2) > 0:
        	    words += spacer + skaitlix[int(digit2)] + 'ty'
    	    if language == 'ru_RU' :
    		if int(digit2) > 1 and int(digit2) < 4:
    		    words += spacer + skaitlix[int(digit2)] + 'дцать'
    		elif digit2 == '4':
    		    words += spacer + 'сорок'
    		elif int(digit2) >= 5 and int(digit2) != 9:
    		    words += spacer + skaitlix[int(digit2)] + 'десят'
    		elif digit2 == '9':
    		    words += spacer + 'девяносто'
    # processing ones
    if chunklength > 0 and digit2 != '1' :
        spacer = ''
        if len(words) > 0 : spacer = ' '
        if language == 'lv_LV' or language == 'en_US' :
    	    if int(digit3) > 0 : words += spacer + skaitli[int(digit3)]
    	elif language == 'ru_RU' :
    	    if chunknr == 1 :
    		if int(digit3) == 1 : words += spacer + 'одна'
    		elif int(digit3) == 2 : words += spacer + 'две'
    		elif int(digit3) >= 3 and int(digit3) != 0: words += spacer + skaitli[int(digit3)]
    	    else:
    		if int(digit3) > 0 : words += spacer + skaitli[int(digit3)]
    # end processing
    if len(words) > 0 :
        
        if digit3 == '1' and chunknr > 0:
    	    return words + daudzums[chunknr]
        elif digit3 != '1' and chunknr > 0:
    	    if language == 'lv_LV' or language == 'en_US' :
    		return words + daudzumsx[chunknr]
    	    elif language == 'ru_RU' :
    		 if (int(digit3) == 2 or int(digit3) == 3 or int(digit3) == 4) and digit2 != '1' :
    		    if chunknr == 1 :
    			return words + ' тысячи'
    		    elif chunknr == 2 :
    			return words + ' миллионa'
    		    elif chunknr == 3 :
    			return words + ' миллиардa'
    		 else:
    		    return words + daudzumsx[chunknr]
    	else:
    	    return words
    else:
    	return ''

