##############################################################################
#
# Copyright (c) 2008-2009 SIA "KN dati". (http://kndati.lv) All Rights Reserved.
#                    General contacts <info@kndati.lv>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from code128 import get_code
from EANBarCode import EanBarCode
import StringIO

def make_barcode(code, code_type='EAN13', rotate=None, height=50, xw=1):
    if code_type.lower()=='ean13':
        bar=EanBarCode()
        im = bar.getImage(code,height)
    elif code_type.lower()=='code128':
        im = get_code(code, xw, height)

    tf = StringIO.StringIO()
    try:
        if rotate!=None:
            im=im.rotate(int(rotate))
    except Exception, e:
        pass
    im.save(tf, 'png')
    import relatorio
    if relatorio.__version__ >= '0.5.2':
        size_x = str(im.size[0]/96.0)+'in'
        size_y = str(im.size[1]/96.0)+'in'
        return tf, 'image/png', size_x, size_y
    else:
        return tf, 'image/png'

