# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

"""wizard to show blockade cases report"""

import wizard
import pooler
from tools.translate import _

FORM = """<?xml version = "1.0"?>
<form string = "Blockade Case Report">
    <field name = "case_id"/>
</form>
"""

FIELDS = {
    'case_id' : {
        'string':'Blockade cases',
        'type':'many2one',
        'relation':'block.prodlot.cases',
        'required':True
    },
}

def _get_default_project(self, cr, uid, ids, context):
    """complete the initial form"""
    obj_case = pooler.get_pool(cr.dbname).get('block.prodlot.cases')
    case_ids = obj_case.search(cr, uid, [])
    if not case_ids:
        raise wizard.except_wizard(_('Warning !'), _("""Any blockade cases!"""))
    return {'case_id' : case_ids[0]}

class wizard_report(wizard.interface):
    """wizard to show blockade cases report"""
    states = {
        'init': {
            'actions': [_get_default_project],
            'result': {'type': 'form', 'arch': FORM, 'fields': FIELDS, 'state': [('end', 'Cancel'), ('print', 'Print')]},
        },
        'print': {
            'actions': [],
            'result': {'type':'print', 'report':'report.affected.partners.by.blockade', 'state':'end'},
        },
    }

wizard_report('pxgo_stock_block_prodlots.affected_partners_blockade_cases')

# vim:expandtab:smartindent:tabstop=4:softtabstop=4:shiftwidth=4:
