# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

"""wizard that add the functionally of blocked a production lot and prodlots affected"""

import wizard
import pooler
from tools.translate import _

FORM = """<?xml version="1.0"?>
<form string="Lock Production Lot">
    <separator colspan="4" string="Lock specific production lot" />
    <field name="case_name" colspan="4"/>
    <newline/>
    <field name="prodlot_id" colspan="2"/>
    <field name="firmness_grade" colspan="4"/>
    <newline/>
    <field name="case_description" colspan="4"/>
</form>
"""

FIELDS = {
    'prodlot_id' : {
        'string':'Production Lot',
        'type':'many2one',
        'relation':'stock.production.lot',
        'required': True,
        'readonly': True
    },
    'case_name': {
        'string': 'Block reason',
        'type': 'char',
        'size': 64,
        'required': True
    },
    'case_description': {
        'string': 'Description',
        'type': 'text',
        'required': True
    },
    'firmness_grade': {
        'string': 'Firmness',
        'type': 'selection',
        'selection': [('pessimistic', 'Pessimistic'), ('optimistic', 'Optimistic')],
        'required': True,
        'help': "Pessimistic block upstream and downstream, optimistic only upstream"
    }
}

def _pre_init(self, cr, uid, data, context):
    """set default value to prodlot_id"""
    return {'prodlot_id': data['id']}

def _lock_production_lot(self, cr, uid, data, context={}):
    """set in_alert a production lot and the affected lots"""
    #gets the objects
    production_lot_obj = pooler.get_pool(cr.dbname).get('stock.production.lot')
    block_prodlot_case_obj = pooler.get_pool(cr.dbname).get('block.prodlot.cases')
    obj_ui_view = pooler.get_pool(cr.dbname).get('ir.ui.view')

    if data['form']['prodlot_id']:
        obj_prodlot_id = production_lot_obj.browse(cr, uid, data['form']['prodlot_id'])
        #if the production lot already blocked, raises an exception
        if obj_prodlot_id.blocked:
            raise wizard.except_wizard(_('Message !'), _('The production lot is blocked yet.'))
        elif obj_prodlot_id.in_alert:
            raise wizard.except_wizard(_('Message !'), _('The production lot is blocked yet.'))
        else:
            if data['form']['firmness_grade'] == 'optimistic':
                optimistic = True
            else:
                optimistic = False

            #gets all prodlots when this prodlot tooks part
            affected_prodlots = production_lot_obj.search_affected_prodlots(cr, uid, obj_prodlot_id.id, optimistic)

            affected_prodlots.append(obj_prodlot_id.id)

            block_prodlot_case_obj.create(cr, uid, {
                                            'name': data['form']['case_name'],
                                            'description': data['form']['case_description'],
                                            'blocked_prodlots_ids': [(6, 0, affected_prodlots)],
                                            'parent_block_prodlot': obj_prodlot_id.id
                                            })

            production_lot_obj.write(cr, uid, affected_prodlots, {})

            view_id = obj_ui_view.search(cr, uid, [('model', '=', 'block.prodlot.cases'), ('type', '=', 'tree')])[0]

            return {
                'name': _('Block Prodlot Case'),
                'view_type': 'form',
                'view_mode': 'tree,form',
                'res_model': 'block.prodlot.cases',
                'type': 'ir.actions.act_window',
                'view_id': (view_id, 'View'),
                'domain': [('description', '=', data['form']['case_description']), ('name', '=', data['form']['case_name']), ('parent_block_prodlot', '=', obj_prodlot_id.id)]
            }
            
    return {}

class block_production_lot(wizard.interface):
    """wizard that add the functionally of blocked a production lot and prodlots affected"""
    states = {
        'init' : {
            'actions' : [_pre_init],
            'result' : {'type' : 'form',
                    'arch' : FORM,
                    'fields' : FIELDS,
                    'state' : [('end', 'Cancel'), ('lock_production_lot', 'Lock Production Lot') ]}
        },
        'lock_production_lot' : {
            'actions' : [],
            'result' : {'type' : 'action', 'action': _lock_production_lot, 'state' : 'end'}
        },
    }
    
block_production_lot("stock.block.prodlots.block_production_lot")