# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

"""wizard that add a prodlot recursively upstream and downstream to case created in_review state"""

import wizard
import pooler
from tools.translate import _

FORM = """<?xml version="1.0"?>
<form string="Add Production Lot to Blockade Case">
    <separator colspan="4" string="Add specific production lot recursively upstream and downstream in Blockade Case" />
    <field name="case_id" colspan="2"/>
    <newline/>
    <field name="prodlot_id" colspan="2"/>
    <field name="firmness_grade" colspan="4"/>
</form>
"""

FIELDS = {
    'prodlot_id' : {
        'string':'Production Lot',
        'type':'many2one',
        'relation':'stock.production.lot',
        'required': True,
        'readonly': True
    },
    'case_id': {
        'string': 'Blcokade Case',
        'type': 'many2one',
        'relation': 'block.prodlot.cases',
        'required': True,
        'domain': "[('state', '=', 'in_review')]"
    },
    'firmness_grade': {
        'string': 'Firmness',
        'type': 'selection',
        'selection': [('pessimistic', 'Pessimistic'), ('optimistic', 'Optimistic')],
        'required': True,
        'help': "Pessimistic block upstream and downstream, optimistic only upstream"
    }
}

def _pre_init(self, cr, uid, data, context):
    """set default value to prodlot_id and firmness"""
    return {'prodlot_id': data['id'],
            'firmness_grade': 'pessimistic'}

def _lock_production_lot(self, cr, uid, data, context={}):
    """set in_alert a production lot and his affected lots in blockade case opened"""
    #gets the objects
    production_lot_obj = pooler.get_pool(cr.dbname).get('stock.production.lot')
    block_prodlot_case_obj = pooler.get_pool(cr.dbname).get('block.prodlot.cases')
    obj_ui_view = pooler.get_pool(cr.dbname).get('ir.ui.view')

    if data['form']['prodlot_id']:
        obj_prodlot_id = production_lot_obj.browse(cr, uid, data['form']['prodlot_id'])
        #if the production lot already blocked, raises an exception
        obj_case_id = block_prodlot_case_obj.browse(cr, uid, data['form']['case_id'])
        # pylint: disable-msg=W0141
        if obj_case_id.id in map(lambda x: x.id, obj_prodlot_id.blocked_prodlots_cases_ids):
            raise wizard.except_wizard(_('Message !'), _('Production Lot already is in case.'))
        else:
            if data['form']['firmness_grade'] == 'optimistic':
                optimistic = True
            else:
                optimistic = False

            #gets all prodlots when this prodlot tooks part
            affected_prodlots = production_lot_obj.search_affected_prodlots(cr, uid, obj_prodlot_id.id, optimistic)

            affected_prodlots.append(obj_prodlot_id.id)

            # pylint: disable-msg=W0141
            affected_prodlots = list(set(affected_prodlots + map(lambda x: x.id, obj_case_id.blocked_prodlots_ids)))

            block_prodlot_case_obj.write(cr, uid, obj_case_id.id, {
                                            'blocked_prodlots_ids': [(6, 0, affected_prodlots)],
                                            })

            production_lot_obj.write(cr, uid, affected_prodlots, {})

            view_id = obj_ui_view.search(cr, uid, [('model', '=', 'block.prodlot.cases'), ('type', '=', 'tree')])[0]

            return {
                'name': _('Block Prodlot Case'),
                'view_type': 'form',
                'view_mode': 'tree,form',
                'res_model': 'block.prodlot.cases',
                'type': 'ir.actions.act_window',
                'view_id': (view_id, 'View'),
                'domain': [('description', '=', obj_case_id.description), ('name', '=', obj_case_id.name), ('parent_block_prodlot', '=', obj_case_id.parent_block_prodlot.id)]
            }

    return {}

class lock_extra_production_lot_recursively(wizard.interface):
    """wizard that add the functionally of blocked a production lot and prodlots affected"""
    states = {
        'init' : {
            'actions' : [_pre_init],
            'result' : {'type' : 'form',
                    'arch' : FORM,
                    'fields' : FIELDS,
                    'state' : [('end', 'Cancel'), ('lock_production_lot', 'Add Production Lot To Case') ]}
        },
        'lock_production_lot' : {
            'actions' : [],
            'result' : {'type' : 'action', 'action': _lock_production_lot, 'state' : 'end'}
        },
    }

lock_extra_production_lot_recursively("stock.block.prodlots.lock_extra_production_lot_recursively")