# -*- encoding: utf-8 -*-
##############################################################################
#
#    OpenERP, Open Source Management Solution
#    Copyright (C) 2004-2009 Tiny SPRL (<http://tiny.be>). All Rights Reserved
#    $Id$
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################

"""inherits fromk stock_move for checks blocked prodlots"""

from osv import osv, fields
from tools.translate import _

class stock_move(osv.osv):
    """inherits fromk stock_move for checks blocked prodlots"""
    _inherit = "stock.move"

    def get_move_in_location(self, cr, uid, location_id, prodlot_id, qty = 0):
        """returns the move in location"""
        moves = super(stock_move, self).get_move_in_location(cr, uid, location_id, prodlot_id, qty=qty)

        if moves:
            ids_to_remove = []
            for move in self.browse(cr, uid, moves):
                if move.location_dest_id.usage == 'elimination':
                    ids_to_remove.append(move.id)
            ids = list(set(moves) - set(ids_to_remove))
            return ids
        else:
            return moves

    def _check_prodlot_on_alert(self, cr, uid, ids):
        """checks if prodlot is on_alert and is trying move it to internal or customer location"""
        for move in self.browse(cr, uid, ids):
            if move.prodlot_id and move.location_dest_id:
                if move.prodlot_id.in_alert and move.location_dest_id.usage in ['internal', 'customer'] and move.state in ['assigned', 'done']:
                    return False
        return True

    def _check_prodlot_blocked(self, cr, uid, ids):
        """checks if prodlot is blocked and is trying move it to internal or customer location"""
        for move in self.browse(cr, uid, ids):
            if move.prodlot_id and move.location_dest_id:
                if move.prodlot_id.blocked and move.location_dest_id.usage in ['internal', 'customer'] and move.state in ['assigned', 'done'] and move.location_id.usage != 'customer':
                    return False
        return True

    def _default_location_destination(self, cr, uid, context={}):
        """obtiene la ubicación de destino por defecto, si es de tipo devolcuión obtendrá devolución"""
        if context.get('move_line', []):
            if context['move_line'][0]:
                if isinstance(context['move_line'][0], (tuple, list)):
                    return context['move_line'][0][2] and context['move_line'][0][2]['location_dest_id'] or False
                else:
                    move_list = self.pool.get('stock.move').read(cr, uid, context['move_line'][0], ['location_dest_id'])
                    return move_list and move_list['location_dest_id'][0] or False
        if context.get('address_out_id', False):
            if 'type' in context:
                if context['type'] == 'return':
                    return self.pool.get('res.partner.address').browse(cr, uid, context['address_out_id']).partner_id.property_stock_returns.id
            if self.pool.get('res.partner.address').browse(cr, uid, context['address_out_id'], context).partner_id.property_stock_customer:
                return self.pool.get('res.partner.address').browse(cr, uid, context['address_out_id'], context).partner_id.property_stock_customer.id
        return False

    def _default_location_source(self, cr, uid, context={}):
        """obtiene la ubicación de origen por defecto, si es de tipo devolucion cogerá la del cliente"""
        if context.get('move_line', []):
            try:
                return context['move_line'][0][2]['location_id']
            except:
                pass
        if 'type' in context and 'address_out_id' in context:
            if context['type'] == 'return':
                return self.pool.get('res.partner.address').browse(cr, uid, context['address_out_id']).partner_id.property_stock_customer.id

        if context.get('address_in_id', False):
            return self.pool.get('res.partner.address').browse(cr, uid, context['address_in_id'], context).partner_id.property_stock_supplier.id
        return False

    _columns = {
                'towaste': fields.boolean('Eliminated', readonly=True),
                }

    _defaults = {
        'location_id': _default_location_source,
        'location_dest_id': _default_location_destination
    }

    _constraints = [(_check_prodlot_on_alert, 'Cannot move a production lot in alert to internal or customer location', ['in_alert']),
    (_check_prodlot_blocked, 'Cannot move a blocked production lot to internal or customer location', ['blocked'])
    ]

    def onchange_lot_id(self, cr, uid, ids, prodlot_id=False, product_qty=False, loc_id=False, context={}):
        """overwrites this event for shows a warning if the production lot selected is on alert"""
        if not prodlot_id or not loc_id:
            return {}
        res = super(stock_move, self).onchange_lot_id(cr, uid, ids, prodlot_id = prodlot_id, product_qty = product_qty, loc_id = loc_id, context = context)
        if 'warning' in res and len(res['warning']) > 0:
            return {'warning': res['warning'], 'value': {'prodlot_id': False}}
        else:
            obj_prodlot_id = self.pool.get('stock.production.lot').browse(cr, uid, prodlot_id)
            if obj_prodlot_id.in_alert:
                res['warning'] = {
                    'title': _('Production Lot in Alert!'),
                    'message': _('This production lot is on alert because any of compounds are in poor condition'),
                        }
                return {'warning': res['warning']}
            elif obj_prodlot_id.blocked:
                res['warning'] = {
                    'title': _('Production Lot Blocked!'),
                    'message': _('This production lot is blocked because it is poor condition'),
                        }
                return {'warning': res['warning'], 'value': {'prodlot_id': False}}
        return res

    def action_done(self, cr, uid, ids, context=None):
        """overwrites this method for that to waste product be marked that eliminated"""
        for move in self.browse(cr, uid, ids):
            if move.location_dest_id.id == move.product_id.product_tmpl_id.property_waste.id:
                self.write(cr, uid, move.id, {'towaste': True})
        return super(stock_move, self).action_done(cr, uid, ids, context)

stock_move()
