#!/usr/bin/env python
#coding: utf-8
#
# (c) 2008 Sednacom <http://www.sednacom.fr>
#
# authors :
#  - Brice V. < brice@sednacom.fr >

from osv import osv, fields
import misc

class partner_pricing_policy(osv.osv):
    """ Pricing policy """
    _name = "partner.pricing.policy"
    _description = __doc__
    _columns = {
        "name" : fields.char("Name", size=64, required=True),
        "code" : fields.char("Code", size=8, required=True),
        "sale_pricelist" : fields.many2one("product.pricelist",
                "Sale price list", required=True,
                domain=[('type','=','sale'),]) ,
        "purchase_pricelist" : fields.many2one("product.pricelist",
                "Purchase price list", required=True,
                domain=[('type', '=', 'purchase'),]),
        "active" : fields.boolean("Active"),
    }

    _defaults = {
        "active" : lambda *args: True,
    }

    name_get = misc._generic_codename_get
    name_search = misc._generic_codename_search
    name_get = misc._generic_codename_get

partner_pricing_policy()

