#!/usr/bin/env python
#coding: utf-8
#
# (c) 2008 Sednacom <http://www.sednacom.fr>
#
# authors :
#  - Brice V. < brice@sednacom.fr >

from osv import osv, fields

class sale_order(osv.osv):
    """ Sale order with pricing policy """
    _name = "sale.order"
    _inherit = "sale.order"
    _columns = {
        "purchase_pricelist" : fields.many2one("product.pricelist",
                "Purchase price list", readonly=True,
                states={'draft' : {'readonly' : False}}),
    }

    def onchange_partner_id(self, cr, uid, ids, part):
        if not part:
            ret = {
                "value" : {
                    "partner_invoice_id": False,
                    "partner_shipping_id":False,
                    "partner_order_id":False,
                    "pricelist_id": False,
                    "purchase_pricelist" : False,
                }
            }
            return ret

        addr = self.pool.get("res.partner").address_get(cr, uid, [part], ["delivery","invoice","contact"])
        b_partner = self.pool.get("res.partner").browse(cr, uid, part)
        if b_partner.pricing_policy:
            pricelist = b_partner.pricing_policy.sale_pricelist.id
            purchase_pricelist = b_partner.pricing_policy.purchase_pricelist.id
        else:
            pricelist = b_partner.property_product_pricelist.id
            purchase_pricelist = False

        ret = {
            "value" : {
                "partner_invoice_id": addr["invoice"],
                "partner_order_id":addr["contact"],
                "partner_shipping_id":addr["delivery"],
                "pricelist_id": pricelist,
                "purchase_pricelist" : purchase_pricelist,
            }
        }
        return ret

    def action_ship_create(self, cr, uid, soids, *args):
        res = super(sale_order, self).action_ship_create(cr, uid, soids, args)
        # update procurements to set purchase pricelist id

        sql = """
            update mrp_procurement mp
            set sale_order = so.id
            from sale_order so, sale_order_line sol
            where
            sol.order_id in (%s)
            and so.id = sol.order_id
            and mp.id = sol.procurement_id
        """ % ', '.join([str(soid) for soid in soids])

        cr.execute(sql)
        return res

sale_order()


