#!/usr/bin/env python
#coding: utf-8
#
# (c) 2008 Sednacom <http://www.sednacom.fr>
#
# authors :
#  - Brice V. < brice@sednacom.fr >

from osv import osv, fields
from mx import DateTime

class mrp_procurement(osv.osv):
    """Procurement with pricing policy implementation"""
    _name = "mrp.procurement"
    _inherit = "mrp.procurement"
    _description = __doc__

    _columns = {
        "sale_order" : fields.many2one("sale.order",
            "Sale order"),
    }

    def action_po_assign(self, cr, uid, ids):
        purchase_id = False
        for procurement in self.browse(cr, uid, ids):

            if procurement.sale_order and procurement.sale_order.purchase_pricelist:
                pricelist_id = procurement.sale_order.purchase_pricelist.id
                dest_address_id = procurement.sale_order.partner_shipping_id.id
                sql = "select purchase_id from mrp_procurement where sale_order = %s order by 1" % procurement.sale_order.id
                cr.execute(sql)
                res = list(set([rec[0] for rec in cr.fetchall() if rec[0] ]))
                if res:
                    purchase_id = res[0]
                else:
                    purchase_id = False # not required, but we never know
            else:
                pricelist_id = partner.property_product_pricelist_purchase.id
                dest_address_id = False

            res_id = procurement.move_id.id
            partner = procurement.product_id.seller_ids[0].name
            partner_id = partner.id
            address_id = self.pool.get('res.partner').address_get(cr, uid, [partner_id], ['default'])['default']

            uom_id = procurement.product_id.uom_po_id.id

            qty = self.pool.get('product.uom')._compute_qty(cr, uid, procurement.product_uom.id, procurement.product_qty, uom_id)
            if procurement.product_id.seller_ids[0].qty:
                qty=max(qty,procurement.product_id.seller_ids[0].qty)

            price = self.pool.get('product.pricelist').price_get(cr, uid, [pricelist_id], procurement.product_id.id, qty, False, {'uom': uom_id})[pricelist_id]

            newdate = DateTime.strptime(procurement.date_planned, '%Y-%m-%d') - DateTime.RelativeDateTime(days=procurement.product_id.product_tmpl_id.seller_delay or 0.0)
            line = {
                'name': procurement.product_id.name,
                'product_qty': qty,
                'product_id': procurement.product_id.id,
                'product_uom': uom_id,
                'price_unit': price,
                'date_planned': newdate.strftime('%Y-%m-%d'),
                'taxes_id': [(6, 0, [x.id for x in procurement.product_id.product_tmpl_id.supplier_taxes_id])],
                'move_dest_id': res_id,
            }
            if purchase_id:
                line['order_id'] = purchase_id
                pol_id = self.pool.get('purchase.order.line').create(cr, uid, line)
            else:
                purchase_id = self.pool.get('purchase.order').create(cr, uid, {
                    'origin': procurement.origin,
                    'partner_id': partner_id,
                    'partner_address_id': address_id,
                    'dest_address_id' : dest_address_id,
                    'location_id': procurement.location_id.id,
                    'pricelist_id': pricelist_id,
                    'order_line': [(0,0,line)]
                })

            self.write(cr, uid, [procurement.id], {'state':'running', 'purchase_id':purchase_id})
        return purchase_id

mrp_procurement()
