# -*- encoding: utf-8 -*-
#########################################################################
#                                                                       #
# Copyright (C) 2011  EON InfoSys                                       #
# Authour: Manas Bala                                                   #
#                                                                       #
#This program is free software: you can redistribute it and/or modify   #
#it under the terms of the GNU General Public License as published by   #
#the Free Software Foundation, either version 3 of the License, or      #
#(at your option) any later version.                                    #
#                                                                       #
#This program is distributed in the hope that it will be useful,        #
#but WITHOUT ANY WARRANTY; without even the implied warranty of         #
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          #
#GNU General Public License for more details.                           #
#                                                                       #
#You should have received a copy of the GNU General Public License      #
#along with this program.  If not, see <http://www.gnu.org/licenses/>.  #
#########################################################################

import time
import netsvc
from osv import fields, osv
from mx import DateTime
from tools import config
from tools.translate import _

class sale_order(osv.osv):
    _inherit = "sale.order"
    
    def action_create_pq(self, cr, uid, ids, context=None):
        i = 0
        seller_ids = []
        po_id = {}
        for sale in self.browse(cr, uid, ids, context=context):
            l_ids = self.pool.get('sale.order.line').search(cr, uid, [('order_id', '=', sale.id)])
            for line in self.pool.get('sale.order.line').browse(cr, uid, l_ids, context=context):
                if line.product_id.seller_id.id:
                    pur_name = self.pool.get('ir.sequence').get(cr, uid, 'purchase.order')
                    pricelist = line.product_id.seller_id.property_product_pricelist_purchase.id
                    product = line.product_id.id
                    qty = line.product_uom_qty
                    partner_id = line.product_id.seller_id.id
                    uom = line.product_uom.id
                    date_order = time.strftime('%Y-%m-%d')
                    
                    if partner_id not in seller_ids:
                        seller_ids.extend([partner_id])
                        po_id[partner_id] = self.pool.get('purchase.order').create(cr, uid, {
                                                                                  'name': pur_name,
                                                                                  'origin': sale.name,
                                                                                  'date_order': date_order,
                                                                                  'partner_id': partner_id,
                                                                                  'location_id': sale.shop_id.warehouse_id.lot_stock_id.id,
                                                                                  'pricelist_id': pricelist,
                                                                                  'state': 'draft',
                                                                                  'shipped': 0,
                                                                                  'invoice_method': 'order',
                                                                                  'invoiced': 0, 
                                                                                  'partner_address_id':self.pool.get('res.partner').address_get(cr, uid, [line.product_id.seller_id.id], ['default'])['default'],
                                                                                  'company_id': self.pool.get('res.company')._company_default_get(cr, uid, 'purchase.order', context=None),
                                                                                  })
                        
                    price = self.pool.get('product.pricelist').price_get(cr, uid, [pricelist],
                                                                         product, qty or 1.0, partner_id, {
                                                                                                           'uom': uom,
                                                                                                           'date': date_order,
                                                                                                           })[pricelist]
                    po_line_id = self.pool.get('purchase.order.line').create(cr, uid, {
                                                                                        'order_id': po_id[partner_id],
                                                                                        'name': line.name,
                                                                                        'product_id': product,
                                                                                        'product_qty': qty,
                                                                                        'state': 'draft',
                                                                                        'invoiced': 0,
                                                                                        'partner_id': partner_id,
                                                                                        'date_order': date_order,
                                                                                        'product_uom': uom,
                                                                                        'price_unit': price,
                                                                                        'date_planned': date_order,
                                                                                        })
                        
        return True;
        
            
        
sale_order()
