# -*- coding: utf-8 -*-
##############################################################################
#    
#    OpenERP, Open Source Enterprise Management Solution
#    Copyright (C) 2004-2010 Tiny SPRL (<http://openerp.com>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.     
#
##############################################################################

from osv import osv

class hrself_holidays_workflow_wizard(osv.osv_memory):
    """Wizard to show the workflow logs of a leave request."""

    _name = 'hrself.holidays.workflow.wizard'

    def show(self, cr, uid, ids, context=None):
        """Show the workflow logs of a leave request."""
        if context is None:
            context = {}
        leave_request_ids = self.pool.get('workflow.logs').search(cr, uid, [
            ('res_type', '=', 'hrself.holidays.request.leave'), 
            ('res_id', 'in', context.get('active_ids'))
        ])
        model_data_object = self.pool.get('ir.model.data')
        model_data_id = model_data_object._get_id(cr, uid, 'base', 'action_workflow_logs_tree')
        window_id = model_data_object.browse(cr, uid, model_data_id, context=context).res_id
        result = self.pool.get('ir.actions.act_window').read(cr, uid, window_id, context=context)
        result['domain'] = [('id', 'in', leave_request_ids)]
        return result
        
hrself_holidays_workflow_wizard()
